/*
 * Created on Sep 4, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.ibm.wtp.internal.emf.workbench.nature;

import java.util.HashSet;
import java.util.Set;

import com.ibm.wtp.common.logger.proxy.Logger;

import org.eclipse.core.runtime.*;

public class EMFNatureRegistry {

	private static final String NATURE_REGISTRATION_POINT = "com.ibm.wtp.emf.workbench.nature_registration"; //$NON-NLS-1$
	private static final String NATURE  = "nature"; //$NON-NLS-1$
	private static final String STATIC_ID = "id"; //$NON-NLS-1$

	/**
	 * Constructor
	 */
	private EMFNatureRegistry() {
		super();
		readRegistry();
	}
	
	private static EMFNatureRegistry singleton;
	
	public final Set REGISTERED_NATURE_IDS = new HashSet();
	
	public static EMFNatureRegistry singleton() {
		if (singleton == null)
			singleton = new EMFNatureRegistry();
		return singleton;
	}
	
	protected void readRegistry() {
	// register Nature IDs for the J2EENatures
		IPluginRegistry r = Platform.getPluginRegistry();
		IConfigurationElement[] ce = r.getConfigurationElementsFor(NATURE_REGISTRATION_POINT);
		String natureId;
		for (int i=0; i<ce.length; i++) {
			if (ce[i].getName().equals(NATURE)) {
				natureId = ce[i].getAttribute(STATIC_ID);
				if (natureId != null)
					registerNatureID(natureId);
			}
		}
	}

	/**
	 * @param natureId
	 */
	private void registerNatureID(String natureId) {
		if (!REGISTERED_NATURE_IDS.contains(natureId))
			REGISTERED_NATURE_IDS.add(natureId);
		else
			Logger.getLogger().logError("Duplicate EMF nature registration for id: "+natureId);
	}

}
