package com.ibm.wtp.internal.emf.workbench;
/*
 * Licensed Material - Property of IBM 
 * (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 */

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotifierImpl;
import com.ibm.wtp.emf.workbench.ProjectResourceSet;

/**
 * This class is used to capture all ADD and REMOVE notifications from each ProjectResourceSet
 * and forward it on to any interrested listeners.  This is to allow you to listen to one object
 * to gain all ADD and REMOVE notifications for each ResourceSet within the system.
 */
public class WorkspaceResourceNotifier extends NotifierImpl {
	protected Adapter projectAdapter = new WorkspaceResourceCacheAdapter();

	class WorkspaceResourceCacheAdapter extends AdapterImpl {
		/**
		 * Forward ADD and REMOVE notification.
		 */
		public void notifyChanged(Notification msg) {
			switch (msg.getEventType()) {
				case Notification.ADD :
				case Notification.ADD_MANY :
				case Notification.REMOVE :
				case Notification.REMOVE_MANY :
					eNotify(msg);
					break;
			}
		}
	}

	/**
	 * Constructor for WorkspaceResourceCache.
	 */
	public WorkspaceResourceNotifier() {
		super();
	}

	/**
	 * Begin listening to a ProjectResourceSet.
	 */
	public void beginListening(ProjectResourceSet aResourceSet) {
		if (aResourceSet != null) { 
			if (aResourceSet.eAdapters() == null ||  
			!aResourceSet.eAdapters().contains(projectAdapter))
			aResourceSet.eAdapters().add(projectAdapter);
		}
	}
	/**
	 * Stop listening to a ProjectResourceSet.
	 */
	public void stopListening(ProjectResourceSet aResourceSet) {
		if (aResourceSet != null)
			aResourceSet.eAdapters().remove(projectAdapter);
	}
}
