package com.ibm.wtp.emf.workbench.plugin;
/*
 * Licensed Material - Property of IBM 
 * (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 */

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.resource.ResourceSet;

import com.ibm.wtp.common.logger.proxy.Logger;
import com.ibm.wtp.emf.workbench.ProjectResourceSet;
import com.ibm.wtp.emf.workbench.ResourceHandler;
import com.ibm.wtp.internal.emf.workbench.ProjectResourceSetImpl;
import com.ibm.wtp.internal.emf.workbench.WorkspaceResourceNotifier;

public class EMFWorkbenchPlugin extends Plugin {
	public static final String ID = "com.ibm.wtp.emf.workbench"; //$NON-NLS-1$
	public static final String WORKSPACE_PROTOCOL = "workspace"; //$NON-NLS-1$
	public static final String PLATFORM_PROTOCOL = "platform"; //$NON-NLS-1$
	public static final String PLATFORM_RESOURCE = "resource"; //$NON-NLS-1$
	public static final String PLATFORM_PLUGIN = "plugin"; //$NON-NLS-1$
	
	private static WorkspaceResourceNotifier sharedCache;
	private static ResourceSet pluginResourceSet;
	private static String[] GLOBAL_LOADING_PLUGIN_NAMES;
	private static EMFWorkbenchPlugin DEFAULT;
	
	public EMFWorkbenchPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		DEFAULT = this;
	}
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	public static EMFWorkbenchPlugin getDefault() {
		return DEFAULT;
	}

	

	/**
	 * Gets the sharedCache.
	 * @return Returns a WorkspaceResourceCache
	 */
	public static WorkspaceResourceNotifier getSharedCache() {
		if (sharedCache == null)
			sharedCache = new WorkspaceResourceNotifier();
		return sharedCache;
	}

	/**
	 * Sets the sharedCache.
	 * @param sharedCache The sharedCache to set
	 */
	public static void setSharedCache(WorkspaceResourceNotifier aSharedCache) {
		sharedCache = aSharedCache;
	}

	/**
	 * @deprecated use createIsolatedResourceSet(IProject)
	 */
	public static ResourceSet createIsolatedResourceSet() {
		return null;
	}

	/**
	 * Add an Adapter to the global WorkspaceCache which is listening to every
	 * ProjectResourceSet in the Workbench.  You can use this api to listen for 
	 * any shared resource being loaded or removed from any ProjectResourceSet
	 * in the Workbench instead of trying to listen to each individual ProjectResourceSet.
	 */
	public static void addWorkspaceEMFResourceListener(Adapter adapter) {
		if (adapter != null && !getSharedCache().eAdapters().contains(adapter))
			getSharedCache().eAdapters().add(adapter);
	}

	/**
	 * @see addWorkspaceEMFResourceListener(Adapter)
	 */
	public static void removeWorkspaceEMFResourceListener(Adapter adapter) {
		if (adapter != null)
			getSharedCache().eAdapters().remove(adapter);
	}
	
	public static boolean isActivated() {
		IPluginDescriptor desc = Platform.getPluginRegistry().getPluginDescriptor(ID);
		if (desc != null)
			return desc.isPluginActivated();
		return false;
	}

	/**
	 * This method will be called when a WorkbenchContext is instantiated
	 * on an EMFNature.
	 * 
	 * @see plugin.xml#ResourceHandlerExtension extension point.
	 */
	public void addExtendedResourceHandlers(ProjectResourceSet aResourceSet) {
		if (aResourceSet == null)
			return;	
		IPluginRegistry registry = Platform.getPluginRegistry();
		IExtensionPoint pct = registry.getExtensionPoint(getDescriptor().getUniqueIdentifier(), "ResourceHandlerExtension"); //$NON-NLS-1$
		IExtension[] extension = pct.getExtensions();
		IExtension config;
		for (int l = 0; l < extension.length; ++l) {
			config = extension[l];
			IConfigurationElement[] cElems = config.getConfigurationElements();
			ResourceHandler handler = null;
			for (int i = 0; i < cElems.length; i++) {
				try {
					handler = (ResourceHandler)cElems[i].createExecutableExtension("run"); //$NON-NLS-1$

				} catch (Exception ex) {
					handler = null;
				}
				if (handler != null)
					aResourceSet.add(handler);
			}
		}
	}
	
	/**
	 * @return
	 */
	public static ResourceSet getPluginResourceSet() {
		if (pluginResourceSet == null)
			pluginResourceSet = new ProjectResourceSetImpl(null);
		return pluginResourceSet;
	}

	/**
	 * @param set
	 */
	public static void setPluginResourceSet(ResourceSet set) {
		pluginResourceSet = set;
	}
	
	public static String[] getGlobalLoadingPluginNames() {
		if (GLOBAL_LOADING_PLUGIN_NAMES == null)
			GLOBAL_LOADING_PLUGIN_NAMES = readGlobalLoadingPluginNames();
		return GLOBAL_LOADING_PLUGIN_NAMES;
	}
	
	public static Logger getLogger() {
		return Logger.getLogger(ID);
	}

	/**
	 * @return
	 */
	private static String[] readGlobalLoadingPluginNames() {
		IPluginRegistry reg = Platform.getPluginRegistry();
		IExtensionPoint exPoint = reg.getExtensionPoint(ID, "globalPluginResourceLoad");
		IExtension[] extensions = exPoint.getExtensions();
		String[] names = new String[extensions.length];
		if (extensions.length > 0) {
			for (int i = 0; i < extensions.length; i++)
				names[i] = extensions[i].getDeclaringPluginDescriptor().getUniqueIdentifier();
		}
		return names;
	}
	


}
