package com.ibm.wtp.emf.workbench.nature;
/*
 * Licensed Material - Property of IBM 
 * (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 */

import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.*;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

import com.ibm.wtp.common.logger.proxy.Logger;
import com.ibm.wtp.emf.workbench.*;
import com.ibm.wtp.internal.emf.workbench.nature.EMFNatureRegistry;

/**
 * @author jlanuti
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class EMFNature implements IProjectNature, IEMFContextContributor {
	protected IProject project;
	protected EMFWorkbenchContextBase emfContext;
	protected boolean hasConfigured = false;
/**
 * EMFNature constructor comment.
 */
public EMFNature() {
	super();
}

/**
 * Adds a nature to a project
 */
protected static void addNatureToProject(IProject proj, String natureId) throws CoreException {
	ProjectUtilities.addNatureToProject(proj, natureId);
}
/** 
 * Configures the project with this nature.
 * This is called by <code>IProject.addNature</code> and should not
 * be called directly by clients.
 * The nature extension id is added to the list of natures on the project by
 * <code>IProject.addNature</code>, and need not be added here.
 *
 * All subtypes must call super.
 *
 * @exception CoreException if this method fails.
 */
public void configure() throws org.eclipse.core.runtime.CoreException {
	if (!hasConfigured) {
		hasConfigured = true;
		primConfigure();
	}
}

protected void primConfigure() throws org.eclipse.core.runtime.CoreException {

}
protected void createEmfContext() throws CoreException {
	WorkbenchResourceHelperBase.createEMFContext(getProject(), this);
}

/**
 * Create a folder relative to the project based on aProjectRelativePathString.
 * @exception com.ibm.itp.core.api.resources.CoreException The exception description.
 */
public IFolder createFolder(String aProjectRelativePathString) throws CoreException {
	if (aProjectRelativePathString != null && aProjectRelativePathString.length() > 0) 
		return createFolder(new Path(aProjectRelativePathString));
	return null;
}
/**
 * Create a folder relative to the project based on aProjectRelativePathString.
 * @exception com.ibm.itp.core.api.resources.CoreException The exception description.
 */
public IFolder createFolder(IPath aProjectRelativePath) throws CoreException {
	if (aProjectRelativePath != null && !aProjectRelativePath.isEmpty()) {
		IFolder folder = getWorkspace().getRoot().getFolder(getProjectPath().append(aProjectRelativePath));
		if (!folder.exists()) {
			ProjectUtilities.ensureContainerNotReadOnly(folder);
			folder.create(true, true, null);
		}
		return folder;
	}
	return null;
}

/** 
 * Removes this nature from the project, performing any required deconfiguration.
 * This is called by <code>IProject.removeNature</code> and should not
 * be called directly by clients.
 * The nature id is removed from the list of natures on the project by
 * <code>IProject.removeNature</code>, and need not be removed here.
 *
 * @exception CoreException if this method fails. 
 */
public void deconfigure() throws org.eclipse.core.runtime.CoreException {
	emfContext = null;
}

/**
 * Return true if the IFile with the given name
 * @aFileName exists in this project.  @aFileName 
 * should be relative to one of the input file paths for the WorkbenchURIConverter.
 */
public boolean fileExists(String aFileName) {
	if (aFileName == null)
		return false;
		
	IPath path = new Path(aFileName);
	if (path.isAbsolute()) 
		return ResourcesPlugin.getWorkspace().getRoot().getFile(path).exists();
	else
		return getWorkbenchURIConverter().canGetUnderlyingResource(aFileName);
}

public ResourceSet getResourceSet() {
	return getEmfContextBase().getResourceSet();
}
/**
 * Return the root location for loading mof resources; defaults to the source folder, subclasses may override
 */
public IContainer getEMFRoot() {
	return getProject();
}
/**
 * Used for optimizations; answers whether a mof context for 
 * this nature has exists yet
 * @deprecated use hasResourceSet();
 */
public boolean hasContext() {
	return hasResourceSet();
}
public boolean hasResourceSet() {
	return emfContext != null && emfContext.hasResourceSet();
}

/**
 * Lazy initializer; for migration of existing workspaces where
 * configure will never get called
 */
protected EMFWorkbenchContextBase getEmfContextBase() {
	if (emfContext == null) {
		try {
			createEmfContext();
		} catch (CoreException ex) {
			Logger.getLogger().logError(ex);
		}
	}
	return emfContext;
}

/**
 * Return an IFile for the file with the given name
 * @aFileName.  @aFileName should be relative to one of the
 * input file paths for the WorkbenchURIConverter.
 */
public IFile getFile(String aFileName) {
	return getWorkbenchURIConverter().getFile(aFileName);
}

/**
 * Return the nature's ID.
 */
public abstract String getNatureID() ;
/**
 * Return the ID of the plugin that this nature is contained within.
 */
protected abstract String getPluginID() ;
/** 
 * Returns the project to which this project nature applies.
 *
 * @return the project handle
 */
public org.eclipse.core.resources.IProject getProject() {
	return project;
}
/**
 * Return the full path of the project.
 */
public IPath getProjectPath() {
	return getProject().getFullPath();
}
/**
 * Get the server property of the project from the supplied key
 * @param key java.lang.String
 * @deprecated we cannont use persistent properties because they are not stored in the repository
 */
protected String getProjectServerValue(String key) {
	if (key == null) return null;
	try {
		QualifiedName wholeName = qualifiedKey(key);
		return getProject().getPersistentProperty(wholeName);
	} catch (CoreException exception) {
		//If we can't find it assume it is null
		exception.printStackTrace();
		return null;
	}
}


/**
 * This method assumes the URIConverter on the ResourceSet is the one that was
 * created for the ResourceSet on behalf of this nature runtime.
 */
protected WorkbenchURIConverter getWorkbenchURIConverter() {
	return (WorkbenchURIConverter) getResourceSet().getURIConverter();
}
public IWorkspace getWorkspace() {
	return getProject().getWorkspace();
}

/**
 * @deprecated use getResource(URI)
 */
public Resource getXmiResource(String uri) {
	return getResource(URI.createURI(uri));
}

public Resource getResource(URI uri) {
	try {
		return getResourceSet().getResource(uri, true);
	} catch (WrappedException ex) {
		if (!WorkbenchResourceHelperBase.isResourceNotFound(ex))
			throw ex;
	}
	return null;
}

/**
 * @deprecated use getResourceSet()
 */
public ResourceSet getXmiResourceSet() {
	return getResourceSet();
}
/**
 * Make sure that all dependent components are initialized before
 * creating the ResourceSet.
 */
protected void initializeDependentComponents() {
	//com.ibm.etools.java.init.JavaInit.init();
}

/**
 * @deprecated use createResource(URI)
 */
public Resource makeXmiResource(String uri) {
	return createResource(URI.createURI(uri));
}
/**
 * @deprecated use createResource(URI)
 */
public Resource makeXmiResource(String uri, EList anExtent) {
	Resource res = makeXmiResource(uri);
	if (res != null)
		res.getContents().addAll(anExtent);
	return res;
}
public Resource createResource(URI uri) {
	return getResourceSet().createResource(uri);
}
/**
 * Return the QualifedValue for key for storage in the repository. The key is qualifed
 * with the package name to avoid collision.
 * @return QualifedName
 * @param key java.lang.String
 */
private QualifiedName qualifiedKey(String key) {
	return new QualifiedName(getPluginID(), key);
}
public static void registerNatureID(String natureID) {
	EMFNatureRegistry.singleton().REGISTERED_NATURE_IDS.add(natureID);
}
/**
 * Sets the project to which this nature applies.
 * Used when instantiating this project nature runtime.
 * This is called by <code>IProject.addNature</code>
 * and should not be called directly by clients.
 *
 * @param project the project to which this nature applies
 */
public void setProject(org.eclipse.core.resources.IProject newProject) {
	project = newProject;
}
/**
 * Set the server property of the project from the supplied value
 * @param key java.lang.String
 * @param value String
 * @deprecated we cannont use persistent properties because they are not stored in the repository
 */
protected void setProjectServerValue(String key, String value) {
	if (key != null) {
		try {
			QualifiedName wholeName = qualifiedKey(key);
			getProject().setPersistentProperty(wholeName, value);
		} catch (CoreException exception) {
			//If we can't find it assume it is null
			exception.printStackTrace();
			return;
		}
	}
}

	/**
	*Shuts down the MOF Nature
	*/
	public void shutdown(){
		if (getResourceSet() != null)
			((ProjectResourceSet)getResourceSet()).release();
	}
	

	/**
	 * Return a list of EMFNatures based on the natures that have been configured.
	 * @return List of EMFNatures
	 * @param project com.ibm.itp.core.api.resources.IProject
	 */
	public static List getRegisteredRuntimes(IProject project) {
		List result = null;
		EMFNature nature = null;
		if (project != null && project.isAccessible()) {
			String natureID;
			Iterator it = EMFNatureRegistry.singleton().REGISTERED_NATURE_IDS.iterator();
			while (it.hasNext()) {
				natureID = (String) it.next();
				try {
					nature = (EMFNature) project.getNature(natureID);
				} catch (CoreException e) { }
				if (nature != null) {
					if (result == null)
						result = new ArrayList(2);
					result.add(nature);
				}
			}
		}
		return result == null ? Collections.EMPTY_LIST : result;
	}
	/**
	 * Return a list of nature IDs
	 * @return List
	 * @param project com.ibm.itp.core.api.resources.IProject
	 */
	public static List getRegisteredRuntimeIDs(IProject project) {
		List result = null;
		String natureID = null;
		if (project != null && project.isAccessible()) {
			Iterator it = EMFNatureRegistry.singleton().REGISTERED_NATURE_IDS.iterator();
			while (it.hasNext()) {
				natureID = (String) it.next();
				try {
					if (project.hasNature(natureID)) {
						if (result == null)
							result = new ArrayList(2);
						result.add(natureID);
					}
				} catch (CoreException e) {}
			}
		}
		return result == null ? Collections.EMPTY_LIST : result;
	}
	
	public static boolean hasRuntime(IProject project, String natureId) {
		if (project == null || !project.isAccessible()) return false;
		try {
			return project.hasNature(natureId);
		} catch (CoreException e) {
			return false;
		}
	}
	
	public static boolean hasRuntime(IProject project, String[] possibleNatureIds) {
		if (project != null) {
			for (int i = 0; i < possibleNatureIds.length; i++) {
				if (hasRuntime(project, possibleNatureIds[i]))
					return true;
			}
		}
		return false;
	}
 
}
