package com.ibm.wtp.emf.workbench;
/*
 * Licensed Material - Property of IBM 
 * (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 */


import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.URIConverter;
/**
 * Insert the type's description here.
 * Creation date: (11/2/2000 9:41:27 AM)
 * @author: Administrator
 */
public interface WorkbenchURIConverter extends URIConverter {
void addInputContainer(IContainer aContainer) ;
void addInputContainers(List containers);
/**
 * Return the IFile relative to the <code>container</code>.
 * This may return null if no file exists.
 */
IFile getFile(String uri) ;
IContainer getInputContainer() ;
List getInputContainers();
IContainer getOutputContainer() ;
void setOutputContainer(IContainer container);
/**
 * Return an IFile for @aPath.
 * If we have a parent and we do not contain the first segment of the @aPath,
 * forward to the parent to retrieve the file.
 */
IFile getOutputFile(IPath aPath) ;
IFile getOutputFileWithMappingApplied(String uri);
boolean removeInputContainer(IContainer aContainer) ;

/**
 * Return true if we can retrieve the resource used to open an input stream on.
 * @param aFileName
 * @return boolean
 */
boolean canGetUnderlyingResource(String aFileName);

boolean isForceSaveRelative() ;

/**
 * Set to true if you do not want any path manipulation when
 * creating the output stream..
 * @param forceSaveRelative The forceSaveRelative to set
 */
void setForceSaveRelative(boolean forceSaveRelative) ;

}
