package com.ibm.wtp.emf.workbench;
/*
 * Licensed Material - Property of IBM 
 * (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 */


import java.io.IOException;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class WorkbenchByteArrayOutputStream extends URIConverterImpl.PlatformResourceOutputStream {
	private boolean fConvertEOL = false;
	protected ResourceSetWorkbenchSynchronizer synchronizer;
	
	/**
	 * WorkbenchByteArrayOutputStream constructor comment.
	 */
	public WorkbenchByteArrayOutputStream(IFile aFile) {
		this(aFile, null);
	}
	/**
	 * WorkbenchByteArrayOutputStream constructor comment.
	 */
	public WorkbenchByteArrayOutputStream(IFile aFile, ResourceSetWorkbenchSynchronizer aSynchronizer) {
		super(aFile, false, true, null);
		synchronizer = aSynchronizer;
	}
	public void close() throws IOException {
		if (synchronizer != null)
			synchronizer.preSave(file);
		super.close();
	}
	/**
	 * Convert the end of line characters.
	 */
	private int convertEOL(byte[] data) {
		// Algorithm: 
		// Remove all '\r' chars
		// Replace all '\n' chars with line seperator chars

		String EOL = System.getProperties().getProperty("line.separator"); //$NON-NLS-1$
		byte[] EOLBytes = EOL.getBytes();

		int out = 0;

		for (int in = 0; in < data.length; in++) {
			if (data[in] == '\r') {
				// don't output (ie, throw the char away)
			} else if (data[in] == '\n') {
				// The code does not currently handle expanding the array				
				if ((in - out + 1) < EOLBytes.length)
					throw new UnsupportedOperationException("WorkbenchByteArrayOutputStream: Expanding EOL chars not implemented"); //$NON-NLS-1$

				for (int i = 0; i < EOLBytes.length; i++) {
					data[out++] = EOLBytes[i];
				}
			} else {
				// Just copy the data
				data[out++] = data[in];
			}
		}

		return out;
	}
	public boolean isConvertEOLChars() {
		return fConvertEOL;
	}
	public void setConvertEOLChars(boolean set) {
		fConvertEOL = set;
	}
	
	/**
	 * @see java.io.ByteArrayOutputStream#toByteArray()
	 */
	public synchronized byte[] toByteArray() {
		byte[] contents = super.toByteArray();
		if (isConvertEOLChars())
			convertEOL(contents);
		return contents;
	}
}
