package com.ibm.wtp.emf.workbench;
/*
 * Licensed Material - Property of IBM 
 * (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 */

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public interface ResourceHandler {
	/**
	 * Each ResourceHandler for a WorkbenchContext (which holds a ProjectResourceSet) will get an oportunity
	 * to get the Resource given the uriString prior to the originatingResourceSet getting it in the normal manner.
	 * 
	 * If this handler loaded a Resource in its create(ResourceSet, uriString) then this method
	 * should be able to return it as well.
	 * 
	 * @return com.ibm.etools.emf.Resource
	 */
	Resource getResource(ResourceSet originatingResourceSet, URI uri);
	
	/**
	 * Each ResourceHandler for a ProjectResourceSet will get an oportunity
	 * to create the Resource with the given uri prior to the originatingResourceSet creating it in the normal manner.
	 * When a resource is created, it will add it to the ResourceSet that created it.
	 * @param originatingResourceSet
	 * @param uri
	 * @param loadOnDemand
	 * @return EObject
	 */
	EObject getEObjectFailed(ResourceSet originatingResourceSet, URI uri, boolean loadOnDemand);

	/**
	 * Each ResourceHandler for a ProjectResourceSet will get an oportunity
	 * to create the Resource with the given uri prior to the originatingResourceSet creating it in the normal manner.
	 * @param originatingResourceSet
	 * @param uri
	 * @return Resource
	 */
	Resource createResource(ResourceSet originatingResourceSet, URI uri);
}
