package com.ibm.wtp.logger.proxyrender;
/*
 * Licensed Material - Property of IBM (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. US
 * Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP
 * Schedule Contract with IBM Corp.
 */

import java.io.*;
import java.util.logging.Level;

import com.ibm.wtp.common.logger.proxy.Logger;

/**
 * The UI Renderer will create a trace file in its scratch area. Creation date: (8/24/2001 12:17:46
 * PM) @author: Administrator
 */
public class DefaultPluginTraceRenderer extends AbstractWorkBenchRenderer {

	public static final String PluginTraceFileName = "/.log"; //$NON-NLS-1$

	private String fTraceFile = null;
	private PrintWriter traceFile = null;

	/**
	 * DefaultUILogRenderer constructor comment.
	 * 
	 * @param logger
	 *            com.ibm.etools.j2ee.logger.Logger
	 */
	public DefaultPluginTraceRenderer(Logger logger) {
		super(logger);

		fTraceFile = fMyPlugin.getStateLocation().toString() + PluginTraceFileName;
		(new File(fTraceFile)).delete(); // Start from fresh ... do not want to leak on disk space

	}
	private void closeTraceFile() {
		if (traceFile == null)
			return;
		try {
			traceFile.flush();
			traceFile.close();
		} finally {
			traceFile = null;
		}
	}
	/**
	 * 
	 * Log in the plugin scrach area. Creation date: (8/24/2001 12:17:46 PM)
	 * 
	 * @return java.lang.String
	 * @param param
	 *            org.eclipse.core.runtime.Status
	 */
	public String log(String msg) {

		System.out.println(msg);

		openTraceFile();
		if (traceFile != null) {
			traceFile.println(msg);
			closeTraceFile();
		}
		return fTraceFile;

	}

	protected void log(String msg, Level l, boolean loggedToWorkbench) {
		if (!loggedToWorkbench || !consoleLogOn) {
			if (l == Level.SEVERE)
				System.err.println(msg);
			else
				System.out.println(msg);
		}

		openTraceFile();
		if (traceFile != null) {
			traceFile.println(msg);
			closeTraceFile();
		}
	}
	
	private void openTraceFile() {
		try {
			traceFile = new PrintWriter(new FileOutputStream(fTraceFile, true));
		} catch (IOException e) {
			// there was a problem opening the log file so log to the console
			traceFile = null;
		}
	}
}
