package com.ibm.wtp.common.logger.proxy;

import java.util.logging.Level;


/*
 * Licensed Material - Property of IBM 
 * (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 */
/**
 * This is the default renderer a Logger will use if 
 * it is not running in the workbench
 * Creation date: (8/24/2001 9:01:10 AM)
 * @author: Administrator
 */
public class JDKConsoleRenderer implements ILogRenderer2 {
  private  boolean       fTraceMode=false;       // will we actually punch trace messaged or not
  private  boolean       fSettingTrace=false ;
  private  Logger        fMyLogger=null ; 

	
/**
 * JDKConsoleRenderer constructor comment.
 */
public JDKConsoleRenderer(Logger logger) {
	super();
	fMyLogger = logger ;
	fTraceMode = fMyLogger.getTraceMode() ;
}
/**
 * Render the status log to the Console only here.
 * Creation date: (8/24/2001 9:01:10 AM)
 * @return description of the log's destination e.g., CONSOLE_DESCRIPTION
 * @param status org.eclipse.core.runtime.IStatus
 */
public String log(String msg, int type) {

	if (type==ILogRenderer.LOG_TRACE && !fTraceMode) return null ;

	if (type==ILogRenderer.LOG_ERROR)
	   System.err.println(msg) ;
	else
	   System.out.println(msg) ;
	return ILogRenderer.CONSOLE_DESCRIPTION;
}
/**
 * Start/Stop Tracing.
 * Creation date: (8/24/2001 9:01:10 AM)
 */
public void setTraceMode(boolean flag) {

	if (fSettingTrace) return ;
	fSettingTrace = true ;
	fTraceMode = flag ;
	fMyLogger.setTraceMode(flag) ;
	fSettingTrace=false ;
}

protected String log(String msg, Level level) {
	if (level == Level.SEVERE)
		System.err.println(msg);
	else
		System.out.println(msg);
	return ILogRenderer.CONSOLE_DESCRIPTION ;
}

	protected boolean isLogging(Level logLevel) {
		return fTraceMode || fMyLogger.isLoggingLevel(logLevel);
	}
	
	/* (non-Javadoc)
	 * @see com.ibm.wtp.common.logger.proxy.ILogRenderer2#log(boolean, java.util.logging.Level)
	 */
	public String log(boolean b, Level level) {
		if (level == DEFAULT)
			level = Level.FINEST;
		if (isLogging(level))
			return log(fMyLogger.getGenericMsg(String.valueOf(b), level), level);
		else
			return NOLOG_DESCRIPTION;
	}

	/* (non-Javadoc)
	 * @see com.ibm.wtp.common.logger.proxy.ILogRenderer2#log(byte, java.util.logging.Level)
	 */
	public String log(byte b, Level level) {
		if (level == DEFAULT)
			level = Level.FINEST;
		if (isLogging(level))
			return log(fMyLogger.getGenericMsg(String.valueOf(b), level), level);
		else
			return NOLOG_DESCRIPTION;
	}

	/* (non-Javadoc)
	 * @see com.ibm.wtp.common.logger.proxy.ILogRenderer2#log(char, java.util.logging.Level)
	 */
	public String log(char c, Level level) {
		if (level == DEFAULT)
			level = Level.FINEST;
		if (isLogging(level))
			return log(fMyLogger.getGenericMsg(String.valueOf(c), level), level);
		else
			return NOLOG_DESCRIPTION;
	}

	/* (non-Javadoc)
	 * @see com.ibm.wtp.common.logger.proxy.ILogRenderer2#log(double, java.util.logging.Level)
	 */
	public String log(double d, Level level) {
		if (level == DEFAULT)
			level = Level.FINEST;
		if (isLogging(level))
			return log(fMyLogger.getGenericMsg(String.valueOf(d), level), level);
		else
			return NOLOG_DESCRIPTION;
	}

	/* (non-Javadoc)
	 * @see com.ibm.wtp.common.logger.proxy.ILogRenderer2#log(float, java.util.logging.Level)
	 */
	public String log(float f, Level level) {
		if (level == DEFAULT)
			level = Level.FINEST;
		if (isLogging(level))
			return log(fMyLogger.getGenericMsg(String.valueOf(f), level), level);
		else
			return NOLOG_DESCRIPTION;
	}

	/* (non-Javadoc)
	 * @see com.ibm.wtp.common.logger.proxy.ILogRenderer2#log(int, java.util.logging.Level)
	 */
	public String log(int i, Level level) {
		if (level == DEFAULT)
			level = Level.FINEST;
		if (isLogging(level))
			return log(fMyLogger.getGenericMsg(String.valueOf(i), level), level);
		else
			return NOLOG_DESCRIPTION;
	}

	/* (non-Javadoc)
	 * @see com.ibm.wtp.common.logger.proxy.ILogRenderer2#log(long, java.util.logging.Level)
	 */
	public String log(long l, Level level) {
		if (level == DEFAULT)
			level = Level.FINEST;
		if (isLogging(level))
			return log(fMyLogger.getGenericMsg(String.valueOf(l), level), level);
		else
			return NOLOG_DESCRIPTION;
	}

	/* (non-Javadoc)
	 * @see com.ibm.wtp.common.logger.proxy.ILogRenderer2#log(java.lang.Object, java.util.logging.Level)
	 */
	public String log(Object o, Level level) {
		if (level == DEFAULT)
			level = Level.FINEST;
		if (isLogging(level))
			return log(fMyLogger.getGenericMsg(String.valueOf(o), level), level);
		else
			return NOLOG_DESCRIPTION;
	}

	/* (non-Javadoc)
	 * @see com.ibm.wtp.common.logger.proxy.ILogRenderer2#log(short, java.util.logging.Level)
	 */
	public String log(short s, Level level) {
		if (level == DEFAULT)
			level = Level.FINEST;
		if (isLogging(level))
			return log(fMyLogger.getGenericMsg(String.valueOf(s), level), level);
		else
			return NOLOG_DESCRIPTION;
	}

	/* (non-Javadoc)
	 * @see com.ibm.wtp.common.logger.proxy.ILogRenderer2#log(java.lang.Throwable, java.util.logging.Level)
	 */
	public String log(Throwable t, Level level) {
		if (level == DEFAULT)
			level = Level.SEVERE;
		if (isLogging(level))
			return log(fMyLogger.getGenericMsg(fMyLogger.exceptionToString(t), level), level);
		else
			return NOLOG_DESCRIPTION;
	}

}
