package com.ibm.wtp.common.logger.proxy;

/*
 * Licensed Material - Property of IBM 
 * (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 */

/**
 * An ILogRenderer will take an IStatus and render its
 * output.
 * Creation date: (8/23/2001 6:04:44 PM)
 * @author: Administrator
 */
public interface ILogRenderer {

	final public static String CONSOLE_DESCRIPTION = "console" ; //$NON-NLS-1$
	final public static String WORKBENCH_DESCRIPTION = "workbench log" ; //$NON-NLS-1$
	final public static String NOLOG_DESCRIPTION = "";	//$NON-NLS-1$
	
	final public static int    LOG_ERROR =   0 ;
	final public static int    LOG_TRACE =   1 ;
	final public static int    LOG_WARNING = 2 ;
	final public static int    LOG_INFO    = 3 ;
	
	final public static String DefaultPluginID = "com.ibm.wtp.common" ; //$NON-NLS-1$

	
	
/**
 * Render the status log.
 * Creation date: (8/23/2001 6:08:20 PM)
 * @return description of the log's destination e.g., CONSOLE_DESCRIPTION 
 */
String log(String msg, int type);
/**
 * Start/Stop Tracing.
 * Creation date: (8/24/2001 8:55:55 AM)
 */
void setTraceMode(boolean Flag);
}
