package com.ibm.wtp.common;
/*
 * Licensed Material - Property of IBM 
 * (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 */
 
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import com.ibm.wtp.common.logger.proxy.Logger;


/**
 * 
 */
public abstract class RegistryReader {
	
	public static final String copyright = "(c) Copyright IBM Corporation 2001."; //$NON-NLS-1$
	IPluginRegistry pluginRegistry = null;
	String pluginId;
	String extensionPointId;

	/**
	 * Utility method to get the plugin id of a configuation element
	 * @param configurationElement
	 * @return
	 */
	public static String getPluginId(IConfigurationElement configurationElement) {
		String pluginId = null;

		if (configurationElement != null) {
			IExtension extension = configurationElement.getDeclaringExtension();

			if (extension != null)
				pluginId = extension.getNamespace();
		}

		return pluginId;
	}
	
	public RegistryReader(IPluginRegistry registry, String plugin, String extensionPoint) {
		super();
		pluginRegistry = registry;
		pluginId = plugin;
		extensionPointId = extensionPoint;
	}
	
	private void internalReadElement(IConfigurationElement element) {
		boolean recognized = this.readElement(element);
		if (!recognized) {
			logError(element, "Error processing extension: " + element); //$NON-NLS-1$
		}
	}
	/**
	 * Logs the error in the desktop log using the provided
	 * text and the information in the configuration element.
	 */
	protected void logError(IConfigurationElement element, String text) {
		IExtension extension = element.getDeclaringExtension();
		IPluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
		StringBuffer buf = new StringBuffer();
		buf.append("Plugin " + descriptor.getUniqueIdentifier() + ", extension " + extension.getExtensionPointUniqueIdentifier()); //$NON-NLS-1$ //$NON-NLS-2$
		buf.append("\n" + text); //$NON-NLS-1$
		Logger.getLogger().logError(buf.toString());
	}
	/**
	 * Logs a very common registry error when a required attribute is missing.
	 */
	protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
		logError(element, "Required attribute '" + attributeName + "' not defined"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	/*
	 * Implement this method to read element attributes. If this element
	 * has subelements, the reader will recursively cycle through them and
	 * call this method so don't do it here.
	 */
	public abstract boolean readElement(IConfigurationElement element);

	/**
	 * read from plugin registry and parse it.
	 */
	public void readRegistry() {
		IExtensionPoint point = pluginRegistry.getExtensionPoint(pluginId, extensionPointId);
		if (point == null)
			return;
		IConfigurationElement[] elements = point.getConfigurationElements();
		for (int i = 0; i < elements.length; i++) {
			internalReadElement(elements[i]);
		}
	}

}
