/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wtp.logger.proxyrender;

import com.ibm.wtp.common.logger.proxy.Logger;
import com.ibm.wtp.common.util.WTPCommonUtilPlugin;
import com.ibm.wtp.logger.proxyrender.ConsoleLogRenderer;
import com.ibm.wtp.logger.proxyrender.DefaultPluginTraceRenderer;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class EclipseLogger
extends Logger {
    public static final String DEBUG_TRACE_OPTION = "/debug/logtrace";
    public static final String DEBUG_TRACE_FILE_OPTION = "/debug/logtracefile";
    public static final String DEBUG_LOG_LEVEL_OPTION = "/debug/loglevel";
    public static final String DEFAULT_OPTION = "default";

    public static Logger getEclipseLogger(Plugin plugin) {
        String id = plugin.getDescriptor().getUniqueIdentifier();
        Logger logger = Logger.getLoggerIfExists(id);
        if (logger != null) {
            return logger;
        }
        logger = Logger.getLogger(id);
        String pluginOption = Platform.getDebugOption((String)(String.valueOf(id) + DEBUG_TRACE_OPTION));
        if (pluginOption == null || DEFAULT_OPTION.equalsIgnoreCase(pluginOption)) {
            pluginOption = Platform.getDebugOption((String)(String.valueOf(WTPCommonUtilPlugin.getDefault().getDescriptor().getUniqueIdentifier()) + DEBUG_TRACE_OPTION));
        }
        boolean logTrace = "true".equalsIgnoreCase(pluginOption);
        pluginOption = Platform.getDebugOption((String)(String.valueOf(id) + DEBUG_TRACE_FILE_OPTION));
        if (pluginOption == null || DEFAULT_OPTION.equalsIgnoreCase(pluginOption)) {
            pluginOption = Platform.getDebugOption((String)(String.valueOf(WTPCommonUtilPlugin.getDefault().getDescriptor().getUniqueIdentifier()) + DEBUG_TRACE_FILE_OPTION));
        }
        boolean logTraceFile = "true".equalsIgnoreCase(pluginOption);
        pluginOption = Platform.getDebugOption((String)(String.valueOf(id) + DEBUG_LOG_LEVEL_OPTION));
        if (pluginOption == null || DEFAULT_OPTION.equalsIgnoreCase(pluginOption)) {
            pluginOption = Platform.getDebugOption((String)(String.valueOf(WTPCommonUtilPlugin.getDefault().getDescriptor().getUniqueIdentifier()) + DEBUG_LOG_LEVEL_OPTION));
        }
        Level logLevel = Level.WARNING;
        if (pluginOption != null) {
            try {
                logLevel = Level.parse(pluginOption);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (logTrace) {
            logger.setTraceMode(true);
        }
        logger.setLevel(logLevel);
        if (!logTraceFile) {
            logger.setRenderer(new ConsoleLogRenderer(logger));
        } else {
            logger.setRenderer(new DefaultPluginTraceRenderer(logger));
        }
        return logger;
    }
}

