/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wtp.common;

import com.ibm.wtp.common.logger.proxy.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;

public abstract class RegistryReader {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    IPluginRegistry pluginRegistry = null;
    String pluginId;
    String extensionPointId;

    public static String getPluginId(IConfigurationElement configurationElement) {
        IExtension extension;
        String pluginId = null;
        if (configurationElement != null && (extension = configurationElement.getDeclaringExtension()) != null) {
            pluginId = extension.getNamespace();
        }
        return pluginId;
    }

    public RegistryReader(IPluginRegistry registry, String plugin, String extensionPoint) {
        this.pluginRegistry = registry;
        this.pluginId = plugin;
        this.extensionPointId = extensionPoint;
    }

    private void internalReadElement(IConfigurationElement element) {
        boolean recognized = this.readElement(element);
        if (!recognized) {
            this.logError(element, "Error processing extension: " + element);
        }
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        IPluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + descriptor.getUniqueIdentifier() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        Logger.getLogger().logError(buf.toString());
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    public abstract boolean readElement(IConfigurationElement var1);

    public void readRegistry() {
        IExtensionPoint point = this.pluginRegistry.getExtensionPoint(this.pluginId, this.extensionPointId);
        if (point == null) {
            return;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.internalReadElement(elements[i]);
            ++i;
        }
    }
}

