/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wtp.internal.emf.workbench;

import com.ibm.wtp.common.RegistryReader;
import com.ibm.wtp.common.logger.proxy.Logger;
import com.ibm.wtp.emf.workbench.EMFWorkbenchContextBase;
import com.ibm.wtp.emf.workbench.IEMFContextContributor;
import com.ibm.wtp.emf.workbench.ResourceSetWorkbenchSynchronizer;
import com.ibm.wtp.emf.workbench.nature.EMFNature;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class EMFWorkbenchContextFactory {
    public static final EMFWorkbenchContextFactory INSTANCE = EMFWorkbenchContextFactory.createFactoryInstance();
    private final Class CONTRIBUTOR_CLASS;
    protected Map emfContextCache;
    static /* synthetic */ Class class$0;

    private static EMFWorkbenchContextFactory createFactoryInstance() {
        EMFWorkbenchContextFactory factory = EMFWorkbenchContextFactory.createFactoryInstanceFromExtension();
        if (factory == null) {
            factory = new EMFWorkbenchContextFactory();
        }
        return factory;
    }

    private static EMFWorkbenchContextFactory createFactoryInstanceFromExtension() {
        final EMFWorkbenchContextFactory[] factoryHolder = new EMFWorkbenchContextFactory[1];
        RegistryReader reader = new RegistryReader(Platform.getPluginRegistry(), "com.ibm.wtp.emf.workbench", "internalWorkbenchContextFactory"){

            public boolean readElement(IConfigurationElement element) {
                if (element.getName().equals("factoryClass")) {
                    try {
                        factoryHolder[0] = (EMFWorkbenchContextFactory)element.createExecutableExtension("name");
                        return true;
                    }
                    catch (CoreException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                }
                return false;
            }
        };
        reader.readRegistry();
        return factoryHolder[0];
    }

    protected EMFWorkbenchContextFactory() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.wtp.emf.workbench.IEMFContextContributor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.CONTRIBUTOR_CLASS = clazz;
        this.emfContextCache = new WeakHashMap();
    }

    protected void cacheEMFContext(IProject aProject, EMFWorkbenchContextBase emfContext) {
        if (aProject != null && emfContext != null) {
            this.emfContextCache.put(aProject, emfContext);
        }
    }

    protected EMFWorkbenchContextBase getCachedEMFContext(IProject aProject) {
        if (aProject != null) {
            return (EMFWorkbenchContextBase)this.emfContextCache.get(aProject);
        }
        return null;
    }

    public void removeCachedProject(IProject aProject) {
        if (aProject != null) {
            this.emfContextCache.remove(aProject);
        }
    }

    public EMFWorkbenchContextBase createEMFContext(IProject aProject, IEMFContextContributor contributor) {
        EMFWorkbenchContextBase context = this.getCachedEMFContext(aProject);
        if (context == null) {
            context = this.primCreateEMFContext(aProject);
            this.cacheEMFContext(aProject, context);
            if (contributor == null) {
                this.initializeEMFContextFromContributors(aProject, context);
            }
        }
        if (contributor != null && context != null) {
            contributor.primaryContributeToContext(context);
        }
        return context;
    }

    protected void initializeEMFContextFromContributors(IProject aProject, EMFWorkbenchContextBase emfContext) {
        if (aProject == null || emfContext == null) {
            return;
        }
        List runtimes = EMFNature.getRegisteredRuntimes(aProject);
        int i = 0;
        while (i < runtimes.size()) {
            IProjectNature nature = (IProjectNature)runtimes.get(i);
            if (nature != null && this.CONTRIBUTOR_CLASS.isInstance(nature)) {
                ((IEMFContextContributor)nature).primaryContributeToContext(emfContext);
            }
            ++i;
        }
    }

    protected boolean isNatureEnabled(IProject aProject, String natureId) {
        try {
            return aProject.isNatureEnabled(natureId);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected String[] getNatureIds(IProject aProject) {
        try {
            if (aProject.isAccessible()) {
                return aProject.getDescription().getNatureIds();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected IProjectNature getNature(IProject aProject, String natureId) {
        try {
            return aProject.getNature(natureId);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected EMFWorkbenchContextBase primCreateEMFContext(IProject aProject) {
        return new EMFWorkbenchContextBase(aProject);
    }

    public EMFWorkbenchContextBase getEMFContext(IProject aProject) {
        return this.getCachedEMFContext(aProject);
    }

    public ResourceSetWorkbenchSynchronizer createSynchronizer(ResourceSet aResourceSet, IProject aProject) {
        return new ResourceSetWorkbenchSynchronizer(aResourceSet, aProject);
    }
}

