/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wtp.emf.workbench;

import com.ibm.wtp.emf.workbench.ISynchronizerExtender;
import com.ibm.wtp.emf.workbench.ProjectResourceSet;
import com.ibm.wtp.emf.workbench.plugin.EMFWorkbenchPlugin;
import com.ibm.wtp.internal.emf.workbench.EMFWorkbenchContextFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ResourceSetWorkbenchSynchronizer
implements IResourceChangeListener {
    protected IProject project;
    protected ResourceSet resourceSet;
    protected List extenders;
    protected IResourceDelta currentProjectDelta;
    private int currentEventType = -1;

    public ResourceSetWorkbenchSynchronizer(ResourceSet aResourceSet, IProject aProject) {
        this.resourceSet = aResourceSet;
        this.project = aProject;
        if (aResourceSet != null && aResourceSet instanceof ProjectResourceSet) {
            ((ProjectResourceSet)aResourceSet).setSynchronizer(this);
        }
        this.initialize();
    }

    public IProject getProject() {
        return this.project;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.currentEventType = event.getType();
        this.currentProjectDelta = null;
        if ((this.currentEventType == 2 || this.currentEventType == 4) && event.getResource().equals((Object)this.getProject())) {
            this.release();
            this.notifyExtendersOfClose();
        }
    }

    protected void notifyExtendersIfNecessary() {
        if (this.currentEventType != 1 || this.extenders == null || this.currentProjectDelta == null) {
            return;
        }
        int i = 0;
        while (i < this.extenders.size()) {
            ISynchronizerExtender extender = (ISynchronizerExtender)this.extenders.get(i);
            extender.projectChanged(this.currentProjectDelta);
            ++i;
        }
    }

    protected void notifyExtendersOfClose() {
        if (this.extenders != null && !this.extenders.isEmpty()) {
            int i = 0;
            while (i < this.extenders.size()) {
                ISynchronizerExtender extender = (ISynchronizerExtender)this.extenders.get(i);
                extender.projectClosed();
                ++i;
            }
        }
    }

    protected IWorkspace getWorkspace() {
        if (this.getProject() == null) {
            return ResourcesPlugin.getWorkspace();
        }
        return this.getProject().getWorkspace();
    }

    protected void initialize() {
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 15);
    }

    public void dispose() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected void release() {
        if (EMFWorkbenchPlugin.isActivated()) {
            EMFWorkbenchContextFactory.INSTANCE.removeCachedProject(this.getProject());
            if (this.resourceSet instanceof ProjectResourceSet) {
                ((ProjectResourceSet)this.resourceSet).release();
            }
            this.dispose();
        }
    }

    public void addExtender(ISynchronizerExtender extender) {
        if (this.extenders == null) {
            this.extenders = new ArrayList(3);
        }
        this.extenders.add(extender);
    }

    public void removeExtender(ISynchronizerExtender extender) {
        if (this.extenders == null) {
            return;
        }
        this.extenders.remove(extender);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '(' + (this.getProject() != null ? this.getProject().getName() : "null") + ')';
    }

    public void preSave(IFile aFile) {
    }
}

