package com.sbsa.coe.plugin.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import com.sbsa.coe.plugin.COEConstants;
import com.sbsa.coe.plugin.COEPlugin;

public class COEPreferencesPageContent extends Composite {

	private Label label = null;
	private Table table = null;
	private static final String TYPE_NAME = "TYPE_NAME"; //$NON-NLS-1$
	private TableItem currentlyCheckedItem;

	public COEPreferencesPageContent(Composite parent, int style) {
		super(parent, style);
		initialize();
	}

	private void initialize() {
		setSize(new Point(365,200));
		setLayout(new GridLayout());
		label = new Label(this, SWT.NONE);
		label.setText("Set Default Layout");
		createDataTable();
	}
	
	private void createDataTable() {
		GridData layout = new GridData();
		layout.grabExcessHorizontalSpace = true;
		layout.verticalAlignment = GridData.CENTER;
		layout.horizontalAlignment = GridData.FILL;
		table = new Table(this, SWT.CHECK | SWT.BORDER);
		table.setLayoutData(layout);
		table.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TableItem selectedItem = (TableItem)e.item;
				if (selectedItem.getChecked()){
//					Ensure only one item can be checked
					if (currentlyCheckedItem != null){
						currentlyCheckedItem.setChecked(false);
					}					
					currentlyCheckedItem = selectedItem;
				} else if(selectedItem == currentlyCheckedItem){
					currentlyCheckedItem = null;
				}
			}
		});		
	}
	public String getLayoutManagerName() {
		if(currentlyCheckedItem != null){
			return (String) currentlyCheckedItem.getData(TYPE_NAME);
		} else {
			return ""; //$NON-NLS-1$
		}
	}

	public void setLayoutManagerName(String layoutManagerName) {
		for (int i = 0; i < table.getItemCount(); i++) {
			TableItem item = table.getItem(i);
			if(layoutManagerName == null || layoutManagerName.length()==0){
				if(item.getData(TYPE_NAME) == null){
					item.setChecked(true);
					currentlyCheckedItem = item;
					continue;
				}
			} else {
				if(layoutManagerName.equals(item.getData(TYPE_NAME))){
					item.setChecked(true);
					currentlyCheckedItem = item;
					continue;
				}
			}
			item.setChecked(false);
		}
	}
	public void init(IPreferenceStore preferenceStore) {
		// Fill the layout table with the allowable layouts
		String[][] layoutItems = COEPlugin.getDefault().getLayoutManagers();
		String defaultLayoutTypeName = preferenceStore.getString(COEConstants.DEFAULT_LAYOUTMANAGER);		
		for (int i = 0; i < layoutItems[0].length; i++) {
			TableItem item = new TableItem(table,SWT.NONE);
			item.setText(layoutItems[0][i]);
			String typeName = layoutItems[1][i];
			item.setData(TYPE_NAME,typeName);
			if(typeName != null && typeName.equals(defaultLayoutTypeName)){
				item.setChecked(true);
				currentlyCheckedItem = item;
			}
		}		
	}

}
