package com.sbsa.coe.plugin.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.sbsa.coe.plugin.COEConstants;
import com.sbsa.coe.plugin.COEPlugin;

/**
 * Extends PreferencePage because we create a Table not a fieldEditor 
 * @author Marius Snyman
 *
 */
public class COEPreferencePage
	extends PreferencePage
	implements IWorkbenchPreferencePage {

	// keep track of preferences
	// fieldEditors do not require this
	private IPreferenceStore preferenceStore;
	// the content Page
	private COEPreferencesPageContent pageContent;

	
	public COEPreferencePage() {
		setPreferenceStore(getStore());
		setDescription("Set the default Layout Manager");
	}
	
	public void init(IWorkbench workbench) {
	}
	
	/**
	 * Prepare the Preference Store
	 * @return
	 */
	private IPreferenceStore getStore() {
		if (preferenceStore != null)
			return preferenceStore;
		preferenceStore = COEPlugin.getDefault().getPreferenceStore();
		return preferenceStore;
	}	
	
	/**
	 * Add the Content Page
	 */
	@Override
	protected Control createContents(Composite parent) {
		noDefaultAndApplyButton();
		pageContent = new COEPreferencesPageContent(parent, SWT.NONE);
		pageContent.init(getStore());
		return pageContent;
	}
		
	/**
	 * Save on OK
	 */
	@Override
	public boolean performOk() {
		preferenceStore.setValue(COEConstants.DEFAULT_LAYOUTMANAGER, pageContent.getLayoutManagerName());
		return true;
	}
	
	/**
	 * Reset to Defaults
	 */
	@Override
	protected void performDefaults() {
		pageContent.setLayoutManagerName(COEConstants.DEFAULT_LAYOUTMANAGER_VALUE);
		super.performDefaults();
	}	
}