package com.sbsa.coe.plugin;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class COEPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "com.sbsa.coe.plugin";
	// Look And Feel
	public static final String DEFAULT_LOOK_AND_FEEL="Synth";
	public static final String DEFAULT_LOOK_AND_FEEL_VALUE="com.sbsa.ds.csf.component.plaf.synth.RBSSynthLookAndFeel";

	// Layout Managers
	private String[][] layoutManagers;
	
	// The shared instance
	private static COEPlugin plugin;
	
	/**
	 * The constructor
	 */
	public COEPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static COEPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}
	/**
	 * Build a list of available Layout Manager
	 * @return
	 */
	public String[][] getLayoutManagers() {
		if (layoutManagers == null) {
			layoutManagers = new String[][] {
					new String[] { COEMessages.LAYOUT_NULL, 
							COEMessages.LAYOUT_FLOW, 
							COEMessages.LAYOUT_BORDER,
							COEMessages.LAYOUT_GRIDBAG, 
							COEMessages.LAYOUT_GRID, 
							COEMessages.LAYOUT_BOX_X_AXIS,
							COEMessages.LAYOUT_BOX_Y_AXIS, 
							COEMessages.LAYOUT_CARD
					},
					new String[] { COEConstants.LAYOUT_NULL_CLASS, 
							COEConstants.LAYOUT_FLOW_CLASS,
							COEConstants.LAYOUT_BORDER_CLASS, 
							COEConstants.LAYOUT_GRIDBAG_CLASS,
							COEConstants.LAYOUT_GRID_CLASS, 
							COEConstants.LAYOUT_BOX_XAXIS_CLASS,
							COEConstants.LAYOUT_BOX_YAXIS_CLASS, 
							COEConstants.LAYOUT_CARD_CLASS 
					} 
			};
		};
		return layoutManagers;
	}	

}
