 
import os
import sys

if 'SUMO_HOME' in os.environ:
    tools = os.path.join(os.environ['SUMO_HOME'], 'tools')
    sys.path.append(tools)
else:
    sys.exit("please declare environment variable 'SUMO_HOME'")

import synchronization_util

from os.path import expanduser

from sumo_env import SumoEnv
from planning_only_agent import PlanningOnlyAgent

home = expanduser("~")


class Example:

    def __init__(self, net_file, route_file):

        self.net_file = net_file
        self.route_file = route_file

        self.dic_exp_conf = {}
        self.dic_path = {}
        self.dic_agent_conf = {}
        self.dic_traffic_env_conf = {}

        self.agent_name = "PlanningOnly"
        self.agent = PlanningOnlyAgent()

        self.path_to_log = home + '/temp'

        self.env = SumoEnv(
            net_file=self.net_file,
            route_file=self.route_file,
            path_to_log=self.path_to_log)

        if self.agent_name == 'PlanningOnly' or self.agent_name == 'FrapWithPlanning':
            self.agent.set_simulation_environment(self.env)

    def run(self):

        execution_name = 'test'

        state, next_action = self.env.reset(execution_name)
        step = 0
        while step < 3600:
            action_list = [None] * len(next_action)

            new_actions_needed = [0]
            for index in new_actions_needed:
                one_state = state[index]

                action = self.agent.choose_action(step, one_state, intersection_index=index)

                action_list[index] = action

            next_state, reward, done, steps_iterated, next_action = self.env.step(action_list)

            state = next_state
            step += steps_iterated

        self.env.end_sumo()

net_file = home + '/temp/regular-intersection__right_on_red.net.xml'
route_file = home + '/temp/regular-intersection.rou.xml'

example = Example(net_file, route_file)
example.run()
