from __future__ import absolute_import
from __future__ import print_function

import os
import sys
import optparse
import random

# we need to import python modules from the $SUMO_HOME/tools directory
if 'SUMO_HOME' in os.environ:
    tools = os.path.join(os.environ['SUMO_HOME'], 'tools')
    sys.path.append(tools)
else:
    sys.exit("please declare environment variable 'SUMO_HOME'")


import time                     # needed for sleep()
import traci                    # TraCI functionality
from sumolib import checkBinary	# Finds the SUMO binaries

#####def start

   

#####def end

def get_options():
    optParser = optparse.OptionParser()
    optParser.add_option("--nogui", action="store_true",
                         default=False, help="run the commandline version of sumo")
    options, args = optParser.parse_args()
    return options

if __name__ == "__main__":
    options = get_options()

    # this script has been called from the command line. It will start sumo as a
    # server, then connect and run
    if options.nogui:
        sumoBinary = checkBinary('sumo')
    else:
        sumoBinary = checkBinary('sumo-gui')


    # We start and close the TraCI connection
    traci.start([sumoBinary,"-n", "train.net.xml", "-r", "flow.rou.xml","-a", "det.add.xml", "--quit-on-end"])

    step = 0

    
    i = 0
    a = {}
    n = 0
    sum = 0
    while traci.simulation.getMinExpectedNumber()>0:
        traci.simulationStep()
        if  step >= i*30 and step < (i+1)*30:  
            n += traci.inductionloop.getLastStepVehicleNumber("Det1_0")
            sum += traci.inductionloop.getLastStepVehicleNumber("Det1_0")*traci.inductionloop.getLastStepMeanSpeed("Det1_0")   
        else:
            if n !=0:
                a[i] = sum/n               
            else:
                a[i] = 0
            i += 1
        step += 1
    print(a)
    traci.close()