import math

import traci
from datetime import datetime
import pandas as pd


# Main simulation loop
def run():
    start = datetime.now()
    print(str(datetime.now()))

    # begin and end times of the simulation in seconds from 00:00
    # begin = 0
    # end = 50000
    seed = 111

    # start Traci
    traci.start(["sumo", "-n", "osm_reserveCopy.net.xml",
                 "-r", "route_res_PS.rou.xml",
                 "--step-length", "1",
                 # "-b", f"{begin}", "-e", f"{end}",
                 "--seed", f"{seed}",
                 "--no-warnings"])

    step = 0

    vehID = 'v_0'
    data = []

    while  traci.simulation.getMinExpectedNumber() > 0: # Runs while vehicles are in simulation
        traci.simulationStep()

        if vehID in traci.vehicle.getIDList():  # Check if vehicle is in simulation
            speed = traci.vehicle.getSpeed(vehID)  # m/s
            distance = traci.vehicle.getDistance(vehID)  # meters
            time = traci.simulation.getTime()  # seconds
            slope = traci.vehicle.getSlope(vehID)
            slope = math.tan(math.radians(slope)) * 100  # Convert to percentage

            # Store
            data.append([vehID, time, speed, distance, slope])

    # close simulation
    traci.close()

    df = pd.DataFrame(data, columns=['id', 'time', 'speed', 'distance', 'slope'])
    df.to_csv('KraussPS_data2.csv', index=False)

    # runtime
    end = datetime.now()
    runtime = end - start
    print("runtime is: " + str(runtime))


if __name__ == '__main__':

    startG = datetime.now()

    run()

    endG = datetime.now()
    runtimeG = endG - startG
    print('Finished in: ' + str(runtimeG))