import itertools
import os
import sys
import optparse
import xml.etree.ElementTree as ET
import numpy as np
import xlsxwriter

#we need to import some python modules from the SUMO_HOME/tools directory
if 'SUMO_HOME' in os.environ:
    tools=os.path.join(os.environ['SUMO_HOME'], 'tools')
    sys.path.append(tools)
else:
    sys.exit("please declare environment variable 'SUMO_HOME")

from sumolib import checkBinary
import traci

def get_options():
    opt_parser=optparse.OptionParser()
    opt_parser.add_option("--nogui", action="store_true", default=False, help="run the commandline version of sumo")
    options, args = opt_parser.parse_args()
    return options

#contains the traci loop
def run(stopList):
    print("hello")
    step =0

    #traci.start([sumoBinary, "-c", "Delay.sumocfg", "--vehroute-output", "vehroute.xml", "--tripinfo-output", "tripinfo.xml"])
    traci.start(["sumo", "-c", "Delay.sumocfg", "--vehroute-output", "vehroute.xml", "--tripinfo-output", "tripinfo.xml"])

    print("The serving vector is", stopList)
    while traci.simulation.getMinExpectedNumber() > 0:
        traci.simulationStep()
        step+=1
        busIDs = traci.vehicle.getIDList()
        for i in range(len(busIDs)):
            sch=stopList[i]
            for j in range(len(sch)):
                if sch[j]==1:
                    traci.vehicle.setBusStop(str(i),str(j), duration=0.5)
                    # setBusStop(self, vehID, stopID, duration=-1073741824.0, until=-1073741824.0, flags=0)
                    # setBusStop(string, string, double, double, integer) -> None
                # stopping condition
        verifyS = 0
        verifyB = 0
        if step > 100:
            for stop in stopIds:
                waitingPassList = traci.simulation.getBusStopWaitingIDList(
                    stop)  # retreives the ids of the passengers waiting at stop
                if len(waitingPassList) == 0:
                    verifyS += 1
            for bus in busIDs:
                persons = traci.vehicle.getPersonIDList(bus)
                if (len(persons)) == 0:
                    verifyB += 1
            if verifyS == len(stopIds) and verifyB == len(busIDs):
                print("This simulation took", step, "steps ")
                traci.close()
                sys.stdout.flush()
                return step

    traci.close()
    sys.stdout.flush()
    return


    traci.close()
    sys.stdout.flush()

def generateBinary(n, Nstops):
    # Size of an integer is
    # assumed to be 32 bits
    arr = []
    for i in range(Nstops - 1, -1, -1):
        k = n >> i
        if (k & 1):
            arr.append(1)
        else:
            arr.append(0)

    return arr


# Press the green button in the gutter to run the script.
if __name__ == '__main__':
    options=get_options()

    my_array = [[0, 77, 34, 6, 14, 5, 3, 2], [0, 0, 55, 43, 89, 17, 31, 6], [0, 0, 0, 22, 53, 20, 57, 7],
                [0, 0, 0, 0, 5, 4, 8, 2], [0, 0, 0, 0, 0, 6, 20, 8], [0, 0, 0, 0, 0, 0, 43, 9],
                [0, 0, 0, 0, 0, 0, 0, 40], [0, 0, 0, 0, 0, 0, 0, 0]]
    Capacity = 22

    # read the adds file to get the stop IDS
    tripinfo = ET.parse('stops.xml')
    root = tripinfo.getroot()
    stopIds = []
    edgeID = []
    for child in root:
        stopIds.append(child.get("id"))
        # read the edge ID and give it to the function because it has the same order as stopID
        edgeID.append(child.get("lane"))
    stops = list(stopIds)
    eID = list(edgeID)

    print("The stops are: ", stops)
    print("The edges are: ", eID)

    # read the vehicles IDs xml  file
    veh = ET.parse('route.rou.xml')
    root = veh.getroot()
    busIds = []
    for child in root:
        if child.tag == "vehicle" and child.get("type") == "Bus":
            busIds.append(child.get("id"))
    print("the bus ids are:", busIds)


    # generating the tuples whose values are greater than 0
    l1 = []
    dic = {}
    for i in range(len(my_array)):  # nb of rows
        for j in range(len(my_array[0])):  # nb of cols
            if my_array[i][j] > 0:
                l1.append((i, j))
                dic[(i, j)] = 0

    Nstops= len(stops)


    #check binary
    if options.nogui:
        sumoBinary = checkBinary('sumo')
    else:
        sumoBinary = checkBinary('sumo-gui')

    #generating a list with all possible combinations a bus can serve
    combs = pow(2, Nstops)
    allCombs = [[1, 1, 1, 1, 1, 1, 1, 1], [0, 1, 1, 1, 0, 1, 1, 1]]
    # for i in range(0, combs):
    #     a = generateBinary(i, Nstops)
    #     if np.sum(a) > 1:
    #         allCombs.append(a)

    DF=[]
    lp=["Bus 0", "Bus 1", "Bus 2", "Delay", "schedule_nb"]
    DF.append(lp)
    schedule_count=0
    #generate a schedule of 3 serving vectors to give it to the run function
    for b1 in allCombs:
        sch = []
        l1 = []
        t1 = []
        for i in range(len(b1)):
            if b1[i] == 1:
                l1.append(i)
        for comb in itertools.combinations(l1, 2):  # generate the tuples of this schedule
            t1.append(comb)

        for b2 in allCombs:
            l2 = []
            t2 = []
            test1 = []
            for j in range(len(b2)):
                if b2[j] == 1:
                    l2.append(j)
            test1 = t1.copy()
            for comb in itertools.combinations(l2, 2):  # generate the tuples of this schedule
                t2.append(comb)

            for b3 in allCombs:
                l3 = []
                t3 = []
                mergelists = []
                test2 = t2.copy()
                for k in range(len(b3)):
                    if b3[k] == 1:
                        l3.append(k)
                test = test1 + test2
                for comb in itertools.combinations(l3, 2):  # generate the tuples of this schedule
                    t3.append(comb)
                    test.append(comb)
                # now check if the lists t2 and t1 will form the keys of the dictionary
                mergelists = list(set(t1 + t2 + t3))  # returns the common elements only
                diff = set(mergelists).intersection(list(dic.keys()))
                if set(diff) == set(dic.keys()):
                    schedule_count+=1
                    schedule="sch"+str(schedule_count)
                    templist=[]
                    print("serves all demand")
                    allSched= [b1,b2,b3]
                    #the run algorithm takes the schedule and the edge ids
                    step= run(allSched)

                    templist.append(b1)
                    templist.append(b2)
                    templist.append(b3)
                    templist.append(step-101)
                    templist.append(schedule)
                    DF.append(templist)
                else:
                    print("Does not serve all demand")

    #Start excel writting

    workbook1=xlsxwriter.Workbook('SumoRealDelay.xlsx')
    worksheet1=workbook1.add_worksheet()
    for i in range(0,len(DF)):
        for j in range(len(DF[i])):
            worksheet1.write(i,j,str(DF[i][j]))
    workbook1.close()




# See PyCharm help at https://www.jetbrains.com/help/pycharm/
