/*
 * Copyright (c) 2006 Deutsche Post World Net
 *                    Deutsche Post AG, SOPSOLUTIONS
 * All rights reserved.
 */
package org.eclipse.stp.xef;

import java.io.InputStream;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

/**
 * @version $Revision: 1.1 $
 */
public class PolicyDetailEditorInput implements IPolicyDetailEditorInput {

	private AssertionInputTO mAssertionTO;
	private EnvironmentInputTO mEnvironmentTO;
	
	
	public PolicyDetailEditorInput(final AssertionInputTO assertionTO, final EnvironmentInputTO environmentTO) {
		mAssertionTO = assertionTO;
		mEnvironmentTO = environmentTO;
	}

	/** (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getName()
	 */
	public String getName() {
		// TODO Auto-generated method stub
		return mAssertionTO.getName();
	}

	/** (non-Javadoc)
	 * @see org.eclipse.stp.xef.IPolicyDetailEditorInput#getStream()
	 */
	public InputStream getStream() {
		return mAssertionTO.getStream();
	}

	/** (non-Javadoc)
	 * @see org.eclipse.stp.xef.IPolicyDetailEditorInput#getCallback()
	 */
	public IPolicyDetailCallback getCallback() {
		return mAssertionTO.getCallback();
	}

	/** (non-Javadoc)
	 * @see org.eclipse.stp.xef.IPolicyDetailEditorInput#getProject()
	 */
	public IProject getProject() {
		return mEnvironmentTO.getProject();
	}

	public ISchemaProvider getSchemaProvider() {
		return mEnvironmentTO.getSchemaProvider();
	}

	public Map<String, Object> getProperties() {
		return mEnvironmentTO.getProperties();
	}

	/** (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#exists()
	 */
	public boolean exists() {
		// TODO Auto-generated method stub
		return false;
	}

	/** (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getImageDescriptor()
	 */
	public ImageDescriptor getImageDescriptor() {
		// TODO Auto-generated method stub
		return null;
	}

	/** (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getPersistable()
	 */
	public IPersistableElement getPersistable() {
		// TODO Auto-generated method stub
		return null;
	}

	/** (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getToolTipText()
	 */
	public String getToolTipText() {
		// TODO Auto-generated method stub
		return null;
	}

	/** (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		// TODO Auto-generated method stub
		return null;
	}

}
