/*
 * Copyright (c) 2006 Deutsche Post World Net
 *                    Deutsche Post AG, SOPSOLUTIONS
 * All rights reserved.
 */
package org.eclipse.stp.xef;

import java.io.InputStream;

/**
 * <b>This interface represents the callbacks of detail policy editor</b><br>
 * @version $Revision: 1.1 $
 */
public interface IPolicyDetailCallback {

    /**
     * Retrieve context data.
     *
     * @param ctxID Context identifier. 
     * @return Context data.
     */
    Object getData(String ctxID);

    /**
     * Called on save event.
     *
     * @param source Input stream containing updated policy part. 
     * @throws Exception if any error occurs.
     */
    void onSave(final InputStream source) throws Exception;
	
    /**
     * Called on close event.
     */
    void onClose();
	
    /**
     * Called on error event.
     */
    void onError();

}
