
package org.eclipse.stellation.task.client;

import org.eclipse.stellation.task.TaskNotFoundException;

/**
 *
 * A simplified interface for a task service client.  This is the interface that most clients will use to access
 * the task service.  The interface assumes that there is a logged in user associated with it.
 */
public interface StellationTaskServiceClient {
	
	/**
	 * Get the userID of the user who logged in to get this task service client object.
	 * @return the userid
	 */
	public String getUserID();

	/**
	 * Retrieve an object containing information about a particular task.
	 * @param taskid the ID of the task.
	 * @return
	 */
	public StellTask retrieveTask(String taskid) throws TaskNotFoundException;
	
	/**
	 * Create a new task. 
	 * @param taskInfo an implementation specific object value containing the information needed to create
	 * 		a task. This should always include at least a task type, a task name, and a task description.
	 * @return
	 */
	public StellTask createTask(String taskType, String taskName, String taskDescription );
	
	/**
	 * Return a string array containing the names of supported task types.
	 * @return
	 */
	public String[] getSupportedTaskTypes();	
}
