
package org.eclipse.stellation.task;


/**
 * The listener interface for objects that  handle task management conflicts. When
 * a user starts to change a resource as a part of a task (the trigger task), the task system 
 * places a reservation  for the resource. If other tasks (the affected tasks) already have a 
 * reservation for the resource, then a conflict occurs. The system will send an outgoing conflict 
 * notification to the trigger task containing conflict records for each conflicting task; each
 * of the affected tasks will recieve an incoming conflict containing the conflict record for
 * the new conflict.  
 */
public interface TaskConflictListener {
	/** Handle an incoming conflict. An incoming conflict occurs when another task
	 * starts to change something reserved by one of your tasks.
	 * @param conflict the conflict record.
	 */
	public void handleIncomingConflict(TaskConflict conflict);
	
	
	/**
	 * Handle an outgoing conflict. An outgoing conflict is when the target task placed
	 * a reservation that created a task management conflict.
	 * @param conflicts a TaskConflict object for conflicts created.
	 */
	public void handleOutgoingConflict(TaskConflict conflict);
}
