
package org.eclipse.stellation.task;

import java.util.Set;

/**
 * The representation of a conflict notification.
 */
public class TaskConflict {
	
	/**
	 * Create a conflict object
	 * @param conflictID the ID of the conflict.
	 *  @param targetTaskID the ID of the task being notified of the conflict.
	 * @param triggerID the ID of the task that triggered the conflict
	 * @param affectedTasks the ID of all tasks affected by the conflict
	 * @param affectedResources the IDs of all resources in conflict.
	 */
	public TaskConflict(String conflictID, 
									String targetTaskID,
								   String triggerID, 
									Set affectedTasks, Set affectedResources ) {
		_conflictID = conflictID;
		_triggeringTaskID = triggerID;
		_affectedTaskIDs = affectedTasks;
		_affectedResourceIDs = affectedResources;
	}
	
	/**
	 * Get the ID of the conflict
	 * @return the conflict ID
	 */
	public String getConflictID() {
		return _conflictID;
	}
	
	/**
	 * Get theID of the task that triggered the conflict.
	 * @return the task ID
	 */
	public String getTriggerTaskID() {
		return _triggeringTaskID;
	}
	
	/**
	 * Get a list containing the IDs of the tasks affected by the conflict.
	 * @return a List containing task IDs in strings.
	 */
	public Set getAffectedTaskIDs() {
		return _affectedTaskIDs;
	}
	
	/**
	 * Get a list containing the IDs of the resources affected by the conflict.
	 * @return a List containing resource IDs in strings.
	 */
	public Set getAffectedResourceIDs() {
		return _affectedResourceIDs;
	}
	
	public String getTargetTaskID() {
		return _targetTaskID;
	}
	
	protected String _targetTaskID;
	protected String _conflictID;
	protected String _triggeringTaskID;
	protected Set _affectedTaskIDs;
	protected Set _affectedResourceIDs;

}
