
package org.eclipse.stellation.task;

import java.util.Set;
import java.util.TreeSet;

/**
 * The exception triggered when an operation tries to query or operate on a resource
 * within the context of a given task, but the task does not include the resource.
 */
public class ResourceNotIncludedException extends TaskServiceException {


	/**
	 * Create a resource not included exception.
	 * @param taskid the task that does not include the resource
	 * @param resourceid the resource that is not included
	 */
	public ResourceNotIncludedException(String taskid, String resourceid) {
		super("Resource " + resourceid + " not reserved in task " + taskid);
		_taskid = taskid;
		_missingResources = new TreeSet();
		_missingResources.add(resourceid);
	}

	/**
	 * Create a resource not included exception for a case where there are multiple missing
	 * resources.
	 * @param taskid the ID of the task
	 * @param resourceids the IDs of the resources
	 */
	public ResourceNotIncludedException(String taskid, Set resourceids) {
		super("Resources " + resourceids + " not reserved in task " + taskid);
		_taskid = taskid;
		_missingResources = resourceids;
	}
	
	public Set  _missingResources;
	
	protected String _taskid;

}
