
package org.eclipse.stellation.task;

import java.util.Set;
import java.util.TreeSet;

/**
 *  The exception generated when a task operation tries to use an ID which the task
 * service cannot resolve to a resource. (For example, if resource identifiers are
 *  filesystem pathnames, and a user tries to perform an addToTask operation
 * for a filename that doesn't exist in the filesystem, this exception will be triggered.)
 * 
 */
public class ResourceNotFoundException extends TaskServiceException {


	/**
	 * Create a resource not found exception for a single missing resource.
	 * @param s
	 */
	public ResourceNotFoundException(String resourceid) {
		super("Resource " + resourceid + " not found");
		_missingResources = new TreeSet();
		_missingResources.add(resourceid);
	}
	
	public ResourceNotFoundException(Set resourceids) {
		super("Resources " + resourceids + " not found");
		_missingResources = resourceids;
	}
	
	public Set  _missingResources;

}
