/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class PessimisticProviderAction
implements IObjectActionDelegate {
    protected ISelection fSelection;
    protected Shell fShell;
    static /* synthetic */ Class class$0;

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        boolean enabled = action.isEnabled();
        if (enabled != this.checkEnablement()) {
            action.setEnabled(!enabled);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.fShell = part.getSite().getShell();
    }

    protected abstract boolean shouldEnableFor(IResource var1);

    protected boolean checkEnablement() {
        IResource[] resources = this.getSelectedResources();
        if (resources == null || resources.length == 0) {
            return false;
        }
        boolean enabled = false;
        int i = 0;
        while (!enabled && i < resources.length) {
            if (this.shouldEnableFor(resources[i])) {
                enabled = true;
            }
            ++i;
        }
        return enabled;
    }

    protected IResource[] getSelectedResources() {
        ArrayList<Object> resources = null;
        if (!this.fSelection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = ((IStructuredSelection)this.fSelection).iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof IResource) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof IResource)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            IResource[] result = new IResource[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new IResource[0];
    }

    protected boolean isControlled(IResource resource) {
        PessimisticFilesystemProvider provider = this.getProvider(resource);
        if (provider == null) {
            return false;
        }
        return provider.isControlled(resource);
    }

    protected boolean isCheckedOut(IResource resource) {
        PessimisticFilesystemProvider provider = this.getProvider(resource);
        if (provider == null) {
            return false;
        }
        return provider.isCheckedout(resource);
    }

    protected boolean isIgnored(IResource resource) {
        PessimisticFilesystemProvider provider = this.getProvider(resource);
        if (provider == null) {
            return false;
        }
        return provider.isIgnored(resource);
    }

    protected PessimisticFilesystemProvider getProvider(IResource resource) {
        if (resource == null) {
            return null;
        }
        if (resource.getType() == 8) {
            return null;
        }
        return (PessimisticFilesystemProvider)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.eclipse.team.examples.pessimistic.pessimisticnature");
    }

    protected void recursivelyAdd(IResource resource, Set resources) {
        if (this.isControlled(resource) && !this.isIgnored(resource)) {
            if (this.shouldEnableFor(resource)) {
                resources.add(resource);
            }
            if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                IResource[] members = null;
                try {
                    members = container.members();
                }
                catch (CoreException e) {
                    PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Exception traversing members");
                }
                if (members != null) {
                    int i = 0;
                    while (i < members.length) {
                        this.recursivelyAdd(members[i], resources);
                        ++i;
                    }
                }
            }
        }
    }

    protected Map sortByProject(Set resources) {
        HashMap<IProject, HashSet<IResource>> byProject = new HashMap<IProject, HashSet<IResource>>();
        if (resources != null) {
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                IResource resource = (IResource)i.next();
                IProject project = resource.getProject();
                HashSet<IResource> set = (HashSet<IResource>)byProject.get(project);
                if (set == null) {
                    set = new HashSet<IResource>(1);
                    byProject.put(project, set);
                }
                set.add(resource);
            }
        }
        return byProject;
    }

    protected void runWithProgressDialog(IRunnableWithProgress runnable) {
        try {
            new ProgressMonitorDialog(this.fShell).run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problems running action " + this);
        }
        catch (InterruptedException e) {
            PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problems running action " + this);
        }
    }

    public abstract void run(IAction var1);
}

