/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;
import org.eclipse.team.examples.pessimistic.ResourceSetContentProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ResourceChangeListener
implements IResourceDeltaVisitor,
IResourceChangeListener {
    private Set fAdded = new HashSet(1);
    private Set fRemoved = new HashSet(1);

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource != null) {
            IProject project = resource.getProject();
            if (project != null) {
                PessimisticFilesystemProvider provider = (PessimisticFilesystemProvider)RepositoryProvider.getProvider((IProject)project);
                if (provider == null) {
                    return false;
                }
                if (provider.isControlled(resource)) {
                    switch (delta.getKind()) {
                        case 1: 
                        case 4: {
                            return true;
                        }
                        case 2: {
                            this.fRemoved.add(resource);
                            return false;
                        }
                    }
                } else {
                    switch (delta.getKind()) {
                        case 2: 
                        case 4: {
                            return true;
                        }
                        case 1: {
                            if (!provider.isIgnored(resource)) {
                                this.fAdded.add(resource);
                            }
                            return true;
                        }
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private IResource[] toResourceArray(Collection collection) {
        if (collection.isEmpty()) {
            return new IResource[0];
        }
        IResource[] resources = new IResource[collection.size()];
        collection.toArray(resources);
        return resources;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            e.printStackTrace();
            PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Exceptions during resource callback");
        }
        if (!this.fRemoved.isEmpty() || !this.fAdded.isEmpty()) {
            final IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (!ResourceChangeListener.this.fRemoved.isEmpty()) {
                        ResourceChangeListener.this.remove(monitor);
                    }
                    if (!ResourceChangeListener.this.fAdded.isEmpty()) {
                        ResourceChangeListener.this.add(monitor);
                    }
                }
            };
            Runnable run = new Runnable(){

                public void run() {
                    try {
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        if (workspace != null) {
                            workspace.run(workspaceRunnable, null);
                        }
                    }
                    catch (CoreException e) {
                        PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problems encountered during attempt to add/remove control.");
                    }
                }
            };
            new Thread(run).start();
        }
    }

    private int getAddToControlPreference() {
        Preferences preferences = PessimisticFilesystemProviderPlugin.getInstance().getPluginPreferences();
        return preferences.getInt("org.eclipse.team.examples.pessimistic.AddToControl");
    }

    private void add(final IProgressMonitor monitor) {
        switch (this.getAddToControlPreference()) {
            case 4: {
                break;
            }
            case 2: {
                this.addToControl(this.fAdded, monitor);
                break;
            }
            case 1: {
                Shell shell = this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
                    HashSet resources = new HashSet(this.fAdded);
                    Object[] resourceArray = resources.toArray();
                    ResourceSetContentProvider contentProvider = new ResourceSetContentProvider(resources);
                    final CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
                    dialog.setMessage("Select the resources to be added to the control of the repository.");
                    dialog.setTitle("Add resources to control");
                    dialog.setContainerMode(true);
                    dialog.setBlockOnOpen(true);
                    dialog.setSorter((ViewerSorter)new ResourceSorter(1));
                    dialog.setExpandedElements(resourceArray);
                    dialog.setInitialSelections(resourceArray);
                    dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                    Display display = shell.getDisplay();
                    if (display == null) break;
                    Runnable run = new Runnable(){

                        public void run() {
                            Object[] results;
                            int status = dialog.open();
                            if (status == 0 && (results = dialog.getResult()) != null) {
                                HashSet<Object> resources = new HashSet<Object>(results.length);
                                int i = 0;
                                while (i < results.length) {
                                    resources.add(results[i]);
                                    ++i;
                                }
                                ResourceChangeListener.this.addToControl(resources, monitor);
                            }
                        }
                    };
                    display.asyncExec(run);
                    break;
                }
                PessimisticFilesystemProviderPlugin.getInstance().logError(null, "Could not aquire a shell");
            }
        }
        this.fAdded.clear();
    }

    private void addToControl(Collection resources, IProgressMonitor monitor) {
        Map byProject = this.sortByProject(resources);
        Iterator i = byProject.keySet().iterator();
        while (i.hasNext()) {
            IProject project = (IProject)i.next();
            PessimisticFilesystemProvider provider = (PessimisticFilesystemProvider)RepositoryProvider.getProvider((IProject)project);
            if (provider == null) continue;
            provider.addToControl(this.toResourceArray((Collection)byProject.get(project)), monitor);
        }
    }

    private void remove(IProgressMonitor monitor) {
        Map byProject = this.sortByProject(this.fRemoved);
        Iterator i = byProject.keySet().iterator();
        while (i.hasNext()) {
            IProject project = (IProject)i.next();
            PessimisticFilesystemProvider provider = (PessimisticFilesystemProvider)RepositoryProvider.getProvider((IProject)project);
            if (provider == null) continue;
            provider.removeFromControl(this.toResourceArray((Collection)byProject.get(project)), monitor);
        }
        this.fRemoved.clear();
    }

    private Map sortByProject(Collection resources) {
        HashMap<IProject, HashSet<IResource>> byProject = new HashMap<IProject, HashSet<IResource>>();
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            IResource resource = (IResource)i.next();
            IProject project = resource.getProject();
            HashSet<IResource> set = (HashSet<IResource>)byProject.get(project);
            if (set == null) {
                set = new HashSet<IResource>(1);
                byProject.put(project, set);
            }
            set.add(resource);
        }
        return byProject;
    }

    private Shell getShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (window == null && (windows = workbench.getWorkbenchWindows()) != null && windows.length > 0) {
                window = windows[0];
            }
            if (window != null) {
                Shell shell = window.getShell();
                if (shell == null) {
                    return null;
                }
                if (shell.isDisposed()) {
                    return null;
                }
                return shell;
            }
        }
        return null;
    }

    public void startup() {
        ResourcesPlugin.getPlugin();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Resource callback registered");
        }
    }

    public void shutdown() {
        ResourcesPlugin.getPlugin();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Resource callback unregistered");
        }
    }
}

