/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;
import org.eclipse.team.examples.pessimistic.ResourceSetContentProvider;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class PessimisticModificationValidator
implements IFileModificationValidator {
    private PessimisticFilesystemProvider fProvider;

    public PessimisticModificationValidator(PessimisticFilesystemProvider provider) {
        this.fProvider = provider;
    }

    public IStatus validateEdit(IFile[] files, Object context) {
        IFile file;
        if (files.length == 0) {
            return new Status(0, this.getUid(), 0, "OK", null);
        }
        HashSet<IFile> checkOut = new HashSet<IFile>();
        int reloadCount = 0;
        int checkoutFailCount = 0;
        HashMap validateEditStatusMap = new HashMap(files.length);
        int i = 0;
        while (i < files.length) {
            file = files[i];
            if (this.fProvider.isControlled((IResource)file)) {
                if (this.fProvider.isCheckedout((IResource)file)) {
                    PessimisticModificationValidator.setValidateEditStatus(validateEditStatusMap, file, 1);
                } else {
                    checkOut.add(file);
                }
            } else {
                PessimisticModificationValidator.setValidateEditStatus(validateEditStatusMap, file, 1);
            }
            ++i;
        }
        if (!checkOut.isEmpty()) {
            if (context != null) {
                boolean shouldFail = this.shouldFailValidateEdit();
                this.checkout(checkOut, "org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEdited", shouldFail, context);
                if (shouldFail) {
                    return new Status(4, this.getUid(), 4, "Fail Validate Edit Preference true", null);
                }
            } else if (this.isAutomaticCheckout()) {
                if (this.shouldFailValidateEdit()) {
                    return new Status(4, this.getUid(), 4, "Fail Validate Edit Preference true", null);
                }
                this.checkout(checkOut);
            }
            Iterator i2 = checkOut.iterator();
            while (i2.hasNext()) {
                file = (IFile)i2.next();
                if (this.fProvider.isCheckedout((IResource)file)) {
                    if (!this.fProvider.hasContentChanged((IResource)file)) {
                        PessimisticModificationValidator.setValidateEditStatus(validateEditStatusMap, file, 1);
                        continue;
                    }
                    ++reloadCount;
                    PessimisticModificationValidator.setValidateEditStatus(validateEditStatusMap, file, 2);
                    continue;
                }
                ++checkoutFailCount;
            }
        }
        if (reloadCount + checkoutFailCount == 0) {
            return new Status(0, this.getUid(), 0, "OK", null);
        }
        if (checkoutFailCount == files.length) {
            return new Status(4, this.getUid(), 4, "NOTOK", null);
        }
        Status[] children = new Status[files.length];
        int mask = 3;
        int i3 = 0;
        while (i3 < files.length) {
            int result = PessimisticModificationValidator.getValidateEditStatus(validateEditStatusMap, files[i3]);
            children[i3] = (result & mask) != 0 ? new Status(0, this.getUid(), 0, "OK", null) : new Status(4, this.getUid(), 4, "NOTOK", null);
            ++i3;
        }
        return new MultiStatus(this.getUid(), 0, (IStatus[])children, "MULTISTATUS", null);
    }

    public IStatus validateSave(IFile file) {
        int checkedInFilesSaved = this.getPreferences().getInt("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreSaved");
        if (checkedInFilesSaved == 4) {
            return new Status(0, this.getUid(), 0, "", null);
        }
        Status status = new Status(0, this.getUid(), 0, "File is writable", null);
        if (!this.fProvider.isControlled((IResource)file)) {
            return status;
        }
        if (this.fProvider.isIgnored((IResource)file)) {
            return status;
        }
        if (this.fProvider.isCheckedout((IResource)file)) {
            return status;
        }
        HashSet<IFile> files = new HashSet<IFile>(1);
        files.add(file);
        this.checkout(files, "org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreSaved", false, null);
        if (this.fProvider.isCheckedout((IResource)file)) {
            return status;
        }
        return new Status(4, this.getUid(), 4, file.getProjectRelativePath() + " could not be checked out", null);
    }

    private String getUid() {
        return "org.eclipse.team.examples.pessimistic";
    }

    private boolean shouldFailValidateEdit() {
        return this.getPreferences().getBoolean("org.eclipse.team.examples.pessimistic.FailValidateEdit");
    }

    private boolean isAutomaticCheckout() {
        return this.getPreferences().getInt("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEditedNoPrompt") == 2;
    }

    private void promptAndCheckout(Set resources, boolean beQuiet, boolean shouldFail, Object context) {
        if (resources.isEmpty()) {
            return;
        }
        HashSet<Object> temp = new HashSet<Object>(resources.size());
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            IFile resource = (IFile)i.next();
            if (!this.fProvider.isControlled((IResource)resource) || this.fProvider.isCheckedout((IResource)resource)) continue;
            temp.add(resource);
        }
        resources = temp;
        if (!beQuiet && !resources.isEmpty()) {
            Shell shell = this.getShell(context);
            if (shell != null) {
                WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
                Object[] resourceArray = resources.toArray();
                ResourceSetContentProvider contentProvider = new ResourceSetContentProvider(resources);
                CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
                dialog.setMessage("Select resources to be checked out.");
                dialog.setTitle("Check out resources");
                dialog.setContainerMode(true);
                dialog.setBlockOnOpen(true);
                dialog.setSorter((ViewerSorter)new ResourceSorter(1));
                dialog.setExpandedElements(resourceArray);
                dialog.setInitialSelections(resourceArray);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                int status = dialog.open();
                resources = null;
                if (status == 0) {
                    Object[] results = dialog.getResult();
                    resources = new HashSet(results.length);
                    int i2 = 0;
                    while (i2 < results.length) {
                        resources.add(results[i2]);
                        ++i2;
                    }
                }
            } else {
                resources = null;
                PessimisticFilesystemProviderPlugin.getInstance().logError(new RuntimeException(), "Context is invalid: " + context);
            }
        }
        if (resources != null && !resources.isEmpty() && !shouldFail) {
            this.checkout(resources);
        }
    }

    private void checkout(Set resources) {
        if (resources.isEmpty()) {
            return;
        }
        IFile[] checkOut = new IFile[resources.size()];
        resources.toArray(checkOut);
        this.fProvider.checkout((IResource[])checkOut, null);
    }

    private IPreferenceStore getPreferences() {
        return PessimisticFilesystemProviderPlugin.getInstance().getPreferenceStore();
    }

    private void checkout(Set resources, String itemId, boolean shouldFail, Object context) {
        if (resources.isEmpty()) {
            return;
        }
        int preference = this.getPreferences().getInt(itemId);
        if (preference == 4) {
            return;
        }
        boolean beQuiet = false;
        if (preference == 2) {
            beQuiet = true;
        }
        this.promptAndCheckout(resources, beQuiet, shouldFail, context);
    }

    private static void setValidateEditStatus(Map map, IFile resource, int status) {
        map.put(resource, new Integer(status));
    }

    private static int getValidateEditStatus(Map map, IFile resource) {
        Integer i = (Integer)map.get(resource);
        if (i == null) {
            return 0;
        }
        return i;
    }

    private Shell getShell(Object context) {
        if (context instanceof Shell) {
            return (Shell)context;
        }
        if (context instanceof Control) {
            Control control = (Control)context;
            return control.getShell();
        }
        if (context instanceof Widget) {
            Widget widget = (Widget)context;
            return widget.getDisplay().getActiveShell();
        }
        return null;
    }
}

