/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.examples.pessimistic.IResourceStateListener;
import org.eclipse.team.examples.pessimistic.ResourceChangeListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PessimisticFilesystemProviderPlugin
extends AbstractUIPlugin {
    private static PessimisticFilesystemProviderPlugin instance;
    private ResourceChangeListener fListener;
    private List fListeners;
    public static final String PLUGIN_ID = "org.eclipse.team.examples.pessimistic";
    public static final String NATURE_ID = "org.eclipse.team.examples.pessimistic.pessimisticnature";

    public PessimisticFilesystemProviderPlugin(IPluginDescriptor pluginDescriptor) {
        super(pluginDescriptor);
        instance = this;
        this.fListeners = new ArrayList(1);
    }

    public static PessimisticFilesystemProviderPlugin getInstance() {
        return instance;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEdited", 1);
        store.setDefault("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEditedNoPrompt", 2);
        store.setDefault("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreSaved", 2);
        store.setDefault("org.eclipse.team.examples.pessimistic.AddToControl", 1);
        store.setDefault("org.eclipse.team.examples.pessimistic.FailValidateEdit", false);
        store.setDefault("org.eclipse.team.examples.pessimistic.ChangeFileContents", false);
    }

    public void logError(Throwable exception, String message) {
        String pluginId = this.getDescriptor().getUniqueIdentifier();
        Status status = new Status(4, pluginId, 0, message, exception);
        this.getLog().log((IStatus)status);
        if (this.isDebugging()) {
            System.out.println(message);
            exception.printStackTrace();
        }
    }

    public void startup() throws CoreException {
        this.fListener = new ResourceChangeListener();
        this.fListener.startup();
        super.startup();
    }

    public void shutdown() throws CoreException {
        this.fListener.shutdown();
        this.fListener = null;
        super.shutdown();
    }

    public void fireResourcesChanged(IResource[] resources) {
        if (resources == null || resources.length == 0 || this.fListeners.isEmpty()) {
            return;
        }
        Iterator i = this.fListeners.iterator();
        while (i.hasNext()) {
            IResourceStateListener listener = (IResourceStateListener)i.next();
            listener.stateChanged(resources);
        }
    }

    public void addProviderListener(IResourceStateListener listener) {
        if (this.fListeners.contains(listener)) {
            return;
        }
        this.fListeners.add(listener);
    }

    public void removeProviderListener(IResourceStateListener listener) {
        this.fListeners.remove(listener);
    }
}

