/*
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */
package org.eclipse.debug.ui.workflow.internal.engine;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.workflow.Activator;
import org.eclipse.debug.ui.workflow.Messages;
import org.eclipse.debug.ui.workflow.WorkflowExecution;
import org.eclipse.debug.ui.workflow.WorkflowModel;
import org.eclipse.debug.ui.workflow.model.workflow.Element;

public class WorkflowExecutionImpl implements WorkflowExecution {

	/**
	 * To manage sequence of execution, even in background,
	 * we will not use the method DebugUIPlugin.launchInForeground
	 * even if the expected behaviour seems similar.
	 * Specially for the specific case of java application launch, 
	 * which has not been correctly managed (use of sub-process). 
	 */
	public void launchWorkflow(final WorkflowModel workflowModel, final String mode,
			final ILaunch launch, final IProgressMonitor monitor) {
		for (Element element : workflowModel.getAllElements()) {
			if (monitor.isCanceled() && launch.canTerminate()) {
				try {
					launch.terminate();
				} catch (DebugException e) {
					IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, Messages.WorkflowExecutionImpl_unknownError, e);
					Activator.getDefault().getLog().log(status);
				}
			}
			ILaunchConfiguration conf = Utils.getInstance().getLaunchConfigurationFromName(element.getName());
			ILaunchConfigurationWorkingCopy config = null;
			try {
				config = conf.getWorkingCopy();
				monitor.subTask(element.getName() + Messages.WorkflowExecutionImpl_ofType + element.getType());
				ILaunch launchChild = config.launch(mode, new SubProgressMonitor(monitor, 1));
				IProcess[] processes = launchChild.getProcesses();
				for (IProcess process : processes) {
					while (process.isTerminated() == false) {
						Thread.yield();
						Thread.sleep(10);
					}
				}
				monitor.worked(1);
			} catch (CoreException e) {
				IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, Messages.WorkflowExecutionImpl_unknownError, e);
				Activator.getDefault().getLog().log(status);
			} catch (InterruptedException e) {
				IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, Messages.WorkflowExecutionImpl_unknownError, e);
				Activator.getDefault().getLog().log(status);
			}

		}
	}

}
