/*
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */
package org.eclipse.debug.ui.workflow.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.ui.workflow.Activator;
import org.eclipse.debug.ui.workflow.WorkflowController;
import org.eclipse.debug.ui.workflow.WorkflowExecution;
import org.eclipse.debug.ui.workflow.WorkflowModel;
import org.eclipse.debug.ui.workflow.internal.engine.WorkflowControllerImpl;
import org.eclipse.debug.ui.workflow.internal.engine.WorkflowExecutionImpl;
import org.eclipse.debug.ui.workflow.internal.engine.WorkflowModelImpl;

public class WorkflowDelegate implements ILaunchConfigurationDelegate {

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ILaunchConfigurationDelegate#launch(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, org.eclipse.debug.core.ILaunch, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch,
			IProgressMonitor monitor) throws CoreException {
		WorkflowModel workflowModel = new WorkflowModelImpl();
		workflowModel.initialization(configuration);
		monitor.worked(1);
		WorkflowController workflowController = new WorkflowControllerImpl();
		String errorMessage = workflowController.validate(workflowModel);
		if (errorMessage != null) {
			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, errorMessage);
			throw new CoreException(status);
		}
		monitor.worked(1);
		WorkflowExecution executor = new WorkflowExecutionImpl();
		executor.launchWorkflow(workflowModel, mode, launch, monitor);
	}

}
