/*
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */
package org.eclipse.debug.ui.workflow;

import java.util.List;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.workflow.model.workflow.Element;

public interface WorkflowModel extends WorkflowModelEventsSubscribe {

	/**
	 * Allows to retrieve a component at index specified
	 * @param index Component index
	 * @return Return an element
	 */
	public Element getElement(int index);
	
	/**
	 * Allows to retrieve all components of the workflow
	 * @return an element list
	 */
	public List<Element> getAllElements();
	
	/**
	 * If the model has been initialized from a launch configuration,
	 * the name of this configuration will be stored.
	 * @return the name of the current launch configuration, null otherwise.
	 */
	public String getRootConfigName();
	
	/**
	 * Add a component in the workflow
	 * @param element Element which represents a launch configuration
	 */
	public void addElement(Element element);
	
	/**
	 * Change a component in the workflow
	 * @param index Component index
	 * @param element The new element
	 */
	public void setElement(int index, Element element);
	
	/**
	 * To up an element in the workflow 
	 * @param indexSelected Index of item selected
	 */
	public void upElement(int indexSelected);
	
	/**
	 * To down an element in the workflow
	 * @param indexSelected Index of item selected
	 */
	public void downElement(int indexSelected);
	
	/**
	 * Allows to delete a component at index specified
	 * @param index Component index
	 */
	public void removeElement(int index);

	/**
	 * Allows to initialize or load the workflow
	 * @param configuration Launch configuration associated
	 */
	public void initialization(ILaunchConfiguration configuration);
	
	/**
	 * Allows to save the resource
	 * @param configuration Launch configuration associated
	 */
	public void save(ILaunchConfigurationWorkingCopy configuration);

	
}
