/*
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */
package org.eclipse.debug.ui.workflow;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;

public interface WorkflowExecution {
	/**
	 * Allows to launch a model of workflow.
	 * To launch a configuration, see the class WorkflowDelegate.
	 * 
	 * @param workflowModel model of workflow
	 * @param mode Launch mode
	 * @param launch The launcher
	 * @param monitor The progress monitor
	 */
	public void launchWorkflow(WorkflowModel workflowModel, String mode,
			ILaunch launch, IProgressMonitor monitor);
}
