#include "struct.h"

// helper methods

jlong toJLong(FILETIME *target) {
	jlong result = target->dwHighDateTime;
	result = result << 32;
	result = result | target->dwLowDateTime;
	return result;
}

FILETIME toFILETIME(jlong target) {
	FILETIME result;
	result.dwLowDateTime = (DWORD) target;
	result.dwHighDateTime = (DWORD) (target >> 32);
	return result;
}


// USN_RECORD

USN_RECORD_FID_CACHE USN_RECORDFc;

void cacheUSN_RECORDFids(JNIEnv *env, jobject lpObject, PUSN_RECORD_FID_CACHE lpCache)
{
	if (lpCache->cached) return;
	lpCache->clazz = (*env)->GetObjectClass(env, lpObject);
	lpCache->RecordLength = (*env)->GetFieldID(env, lpCache->clazz, "RecordLength", "I");
	lpCache->MajorVersion = (*env)->GetFieldID(env, lpCache->clazz, "MajorVersion", "S");
	lpCache->MinorVersion = (*env)->GetFieldID(env, lpCache->clazz, "MinorVersion", "S");
	lpCache->FileReferenceNumber = (*env)->GetFieldID(env, lpCache->clazz, "FileReferenceNumber", "J");
	lpCache->ParentFileReferenceNumber = (*env)->GetFieldID(env, lpCache->clazz, "ParentFileReferenceNumber", "J");
	lpCache->Usn = (*env)->GetFieldID(env, lpCache->clazz, "Usn", "J");
	lpCache->TimeStamp = (*env)->GetFieldID(env, lpCache->clazz, "TimeStamp", "J");
	lpCache->Reason = (*env)->GetFieldID(env, lpCache->clazz, "Reason", "I");
	lpCache->SourceInfo = (*env)->GetFieldID(env, lpCache->clazz, "SourceInfo", "I");
	lpCache->SecurityId = (*env)->GetFieldID(env, lpCache->clazz, "SecurityId", "I");
	lpCache->FileAttributes = (*env)->GetFieldID(env, lpCache->clazz, "FileAttributes", "I");
	lpCache->FileNameLength = (*env)->GetFieldID(env, lpCache->clazz, "FileNameLength", "S");
	lpCache->FileNameOffset = (*env)->GetFieldID(env, lpCache->clazz, "FileNameOffset", "S");
	lpCache->FileName = (*env)->GetFieldID(env, lpCache->clazz, "FileName", "[B");
	lpCache->cached = 1;
}

/**
 * The jbyte has to be freed later on.
 */
jbyte* getBytes(jsize length, WCHAR *target) {
	jsize i;
	jbyte *result = malloc(length * sizeof(jbyte));
	for (i = 0; i < length; i++)
		result[i] = (jbyte) target[i];
	return result;
}

void setUSN_RECORDFields(JNIEnv *env, jobject lpObject, USN_RECORD *lpStruct)
{
	PUSN_RECORD_FID_CACHE lpCache = &USN_RECORDFc;
	if (!lpCache->cached) cacheUSN_RECORDFids(env, lpObject, lpCache);
	(*env)->SetIntField(env, lpObject, lpCache->RecordLength, (jint)lpStruct->RecordLength);
	(*env)->SetShortField(env, lpObject, lpCache->MajorVersion, (jshort)lpStruct->MajorVersion);
	(*env)->SetShortField(env, lpObject, lpCache->MinorVersion, (jshort)lpStruct->MinorVersion);
	(*env)->SetLongField(env, lpObject, lpCache->FileReferenceNumber, (jlong)lpStruct->FileReferenceNumber);
	(*env)->SetLongField(env, lpObject, lpCache->ParentFileReferenceNumber, (jlong)lpStruct->ParentFileReferenceNumber);
	(*env)->SetLongField(env, lpObject, lpCache->Usn, (jlong)lpStruct->Usn);
	(*env)->SetLongField(env, lpObject, lpCache->TimeStamp, lpStruct->TimeStamp.QuadPart);
	(*env)->SetIntField(env, lpObject, lpCache->Reason, (jint)lpStruct->Reason);
	(*env)->SetIntField(env, lpObject, lpCache->SourceInfo, (jint)lpStruct->SourceInfo);
	(*env)->SetIntField(env, lpObject, lpCache->SecurityId, (jint)lpStruct->SecurityId);
	(*env)->SetIntField(env, lpObject, lpCache->FileAttributes, (jint)lpStruct->FileAttributes);
	(*env)->SetShortField(env, lpObject, lpCache->FileNameLength, (jshort)lpStruct->FileNameLength);
	(*env)->SetShortField(env, lpObject, lpCache->FileNameOffset, (jshort)lpStruct->FileNameOffset);
	{
		jsize length = (lpStruct->FileNameLength) / sizeof(WCHAR);
		jbyteArray fileName = (*env)->NewByteArray(env, length);
		jbyte *name = getBytes(length, (((PBYTE) lpStruct) + lpStruct->FileNameOffset));
		(*env)->SetByteArrayRegion(env, fileName, 0, length, name);
		(*env)->SetObjectField(env, lpObject, lpCache->FileName, fileName);
		free(name);
	}
}

USN_RECORD *getUSN_RECORDFields(JNIEnv *env, jobject lpObject, USN_RECORD *lpStruct)
{
	PUSN_RECORD_FID_CACHE lpCache = &USN_RECORDFc;
	if (!lpCache->cached) cacheUSN_RECORDFids(env, lpObject, lpCache);
	lpStruct->RecordLength = (*env)->GetIntField(env, lpObject, lpCache->RecordLength);
	lpStruct->MajorVersion = (*env)->GetShortField(env, lpObject, lpCache->MajorVersion);
	lpStruct->MinorVersion = (*env)->GetShortField(env, lpObject, lpCache->MinorVersion);
	lpStruct->FileReferenceNumber = (*env)->GetLongField(env, lpObject, lpCache->FileReferenceNumber);
	lpStruct->ParentFileReferenceNumber = (*env)->GetLongField(env, lpObject, lpCache->ParentFileReferenceNumber);
	lpStruct->Usn = (*env)->GetLongField(env, lpObject, lpCache->Usn);
	lpStruct->TimeStamp.QuadPart = (*env)->GetLongField(env, lpObject, lpCache->TimeStamp);
	lpStruct->Reason = (*env)->GetIntField(env, lpObject, lpCache->Reason);
	lpStruct->SourceInfo = (*env)->GetIntField(env, lpObject, lpCache->SourceInfo);
	lpStruct->SecurityId = (*env)->GetIntField(env, lpObject, lpCache->SecurityId);
	lpStruct->FileAttributes = (*env)->GetIntField(env, lpObject, lpCache->FileAttributes);
	{
		jbyteArray lpObject1 = (*env)->GetObjectField(env, lpObject, lpCache->FileName);
		jsize length = (*env)->GetArrayLength(env, lpObject1);
		(*env)->GetByteArrayRegion(env, lpObject1, 0, length, (char *) lpStruct->FileName);
		lpStruct->FileNameOffset = &lpStruct->FileName;
		lpStruct->FileNameLength = (DWORD) length;
	}
	return lpStruct;
}



// USN_JOURNAL_DATA

USN_JOURNAL_DATA_FID_CACHE USN_JOURNAL_DATAFc;

void cacheUSN_JOURNAL_DATAFids(JNIEnv *env, jobject lpObject, PUSN_JOURNAL_DATA_FID_CACHE lpCache)
{
	if (lpCache->cached) return;
	lpCache->clazz = (*env)->GetObjectClass(env, lpObject);
	lpCache->UsnJournalID = (*env)->GetFieldID(env, lpCache->clazz, "UsnJournalID", "J");
	lpCache->FirstUsn = (*env)->GetFieldID(env, lpCache->clazz, "FirstUsn", "J");
	lpCache->NextUsn = (*env)->GetFieldID(env, lpCache->clazz, "NextUsn", "J");
	lpCache->LowestValidUsn = (*env)->GetFieldID(env, lpCache->clazz, "LowestValidUsn", "J");
	lpCache->MaxUsn = (*env)->GetFieldID(env, lpCache->clazz, "MaxUsn", "J");
	lpCache->MaximumSize = (*env)->GetFieldID(env, lpCache->clazz, "MaximumSize", "J");
	lpCache->AllocationDelta = (*env)->GetFieldID(env, lpCache->clazz, "AllocationDelta", "J");
	lpCache->cached = 1;
}

USN_JOURNAL_DATA *getUSN_JOURNAL_DATAFields(JNIEnv *env, jobject lpObject, USN_JOURNAL_DATA *lpStruct)
{
	PUSN_JOURNAL_DATA_FID_CACHE lpCache = &USN_JOURNAL_DATAFc;
	if (!lpCache->cached) cacheUSN_JOURNAL_DATAFids(env, lpObject, lpCache);
	lpStruct->UsnJournalID = (*env)->GetLongField(env, lpObject, lpCache->UsnJournalID);
	lpStruct->FirstUsn = (*env)->GetLongField(env, lpObject, lpCache->FirstUsn);
	lpStruct->NextUsn = (*env)->GetLongField(env, lpObject, lpCache->NextUsn);
	lpStruct->LowestValidUsn = (*env)->GetLongField(env, lpObject, lpCache->LowestValidUsn);
	lpStruct->MaxUsn = (*env)->GetLongField(env, lpObject, lpCache->MaxUsn);
	lpStruct->MaximumSize = (*env)->GetLongField(env, lpObject, lpCache->MaximumSize);
	lpStruct->AllocationDelta = (*env)->GetLongField(env, lpObject, lpCache->AllocationDelta);
	return lpStruct;
}

void setUSN_JOURNAL_DATAFields(JNIEnv *env, jobject lpObject, USN_JOURNAL_DATA *lpStruct)
{
	PUSN_JOURNAL_DATA_FID_CACHE lpCache = &USN_JOURNAL_DATAFc;
	if (!lpCache->cached) cacheUSN_JOURNAL_DATAFids(env, lpObject, lpCache);
	(*env)->SetLongField(env, lpObject, lpCache->UsnJournalID, (jlong)lpStruct->UsnJournalID);
	(*env)->SetLongField(env, lpObject, lpCache->FirstUsn, (jlong)lpStruct->FirstUsn);
	(*env)->SetLongField(env, lpObject, lpCache->NextUsn, (jlong)lpStruct->NextUsn);
	(*env)->SetLongField(env, lpObject, lpCache->LowestValidUsn, (jlong)lpStruct->LowestValidUsn);
	(*env)->SetLongField(env, lpObject, lpCache->MaxUsn, (jlong)lpStruct->MaxUsn);
	(*env)->SetLongField(env, lpObject, lpCache->MaximumSize, (jlong)lpStruct->MaximumSize);
	(*env)->SetLongField(env, lpObject, lpCache->AllocationDelta, (jlong)lpStruct->AllocationDelta);
}



// BY_HANDLE_FILE_INFORMATION

BY_HANDLE_FILE_INFORMATION_FID_CACHE BY_HANDLE_FILE_INFORMATIONFc;

void cacheBY_HANDLE_FILE_INFORMATIONFids(JNIEnv *env, jobject lpObject, PBY_HANDLE_FILE_INFORMATION_FID_CACHE lpCache)
{
	if (lpCache->cached) return;
	lpCache->clazz = (*env)->GetObjectClass(env, lpObject);
	lpCache->nFileIndexLow = (*env)->GetFieldID(env, lpCache->clazz, "nFileIndexLow", "I");
	lpCache->nFileIndexHigh = (*env)->GetFieldID(env, lpCache->clazz, "nFileIndexHigh", "I");
	lpCache->nNumberOfLinks = (*env)->GetFieldID(env, lpCache->clazz, "nNumberOfLinks", "I");
	lpCache->nFileSizeLow = (*env)->GetFieldID(env, lpCache->clazz, "nFileSizeLow", "I");
	lpCache->nFileSizeHigh = (*env)->GetFieldID(env, lpCache->clazz, "nFileSizeHigh", "I");
	lpCache->dwVolumeSerialNumber = (*env)->GetFieldID(env, lpCache->clazz, "dwVolumeSerialNumber", "I");
	lpCache->ftLastWriteTime = (*env)->GetFieldID(env, lpCache->clazz, "ftLastWriteTime", "J");
	lpCache->ftLastAccessTime = (*env)->GetFieldID(env, lpCache->clazz, "ftLastAccessTime", "J");
	lpCache->ftCreationTime = (*env)->GetFieldID(env, lpCache->clazz, "ftCreationTime", "J");
	lpCache->dwFileAttributes = (*env)->GetFieldID(env, lpCache->clazz, "dwFileAttributes", "I");
	lpCache->cached = 1;
}

BY_HANDLE_FILE_INFORMATION *getBY_HANDLE_FILE_INFORMATIONFields(JNIEnv *env, jobject lpObject, BY_HANDLE_FILE_INFORMATION *lpStruct)
{
	PBY_HANDLE_FILE_INFORMATION_FID_CACHE lpCache = &BY_HANDLE_FILE_INFORMATIONFc;
	if (!lpCache->cached) cacheBY_HANDLE_FILE_INFORMATIONFids(env, lpObject, lpCache);
	lpStruct->nFileIndexLow = (*env)->GetIntField(env, lpObject, lpCache->nFileIndexLow);
	lpStruct->nFileIndexHigh = (*env)->GetIntField(env, lpObject, lpCache->nFileIndexHigh);
	lpStruct->nNumberOfLinks = (*env)->GetIntField(env, lpObject, lpCache->nNumberOfLinks);
	lpStruct->nFileSizeLow = (*env)->GetIntField(env, lpObject, lpCache->nFileSizeLow);
	lpStruct->nFileSizeHigh = (*env)->GetIntField(env, lpObject, lpCache->nFileSizeHigh);
	lpStruct->dwVolumeSerialNumber = (*env)->GetIntField(env, lpObject, lpCache->dwVolumeSerialNumber);
	lpStruct->ftLastWriteTime = toFILETIME((*env)->GetLongField(env, lpObject, lpCache->ftLastWriteTime));
	lpStruct->ftLastAccessTime = toFILETIME((*env)->GetLongField(env, lpObject, lpCache->ftLastAccessTime));
	lpStruct->ftCreationTime = toFILETIME((*env)->GetLongField(env, lpObject, lpCache->ftCreationTime));
	lpStruct->dwFileAttributes = (*env)->GetIntField(env, lpObject, lpCache->dwFileAttributes);
	return lpStruct;
}

void setBY_HANDLE_FILE_INFORMATIONFields(JNIEnv *env, jobject lpObject, BY_HANDLE_FILE_INFORMATION *lpStruct)
{
	PBY_HANDLE_FILE_INFORMATION_FID_CACHE lpCache = &BY_HANDLE_FILE_INFORMATIONFc;
	if (!lpCache->cached) cacheBY_HANDLE_FILE_INFORMATIONFids(env, lpObject, lpCache);
	(*env)->SetIntField(env, lpObject, lpCache->nFileIndexLow, (jint)lpStruct->nFileIndexLow);
	(*env)->SetIntField(env, lpObject, lpCache->nFileIndexHigh, (jint)lpStruct->nFileIndexHigh);
	(*env)->SetIntField(env, lpObject, lpCache->nNumberOfLinks, (jint)lpStruct->nNumberOfLinks);
	(*env)->SetIntField(env, lpObject, lpCache->nFileSizeLow, (jint)lpStruct->nFileSizeLow);
	(*env)->SetIntField(env, lpObject, lpCache->nFileSizeHigh, (jint)lpStruct->nFileSizeHigh);
	(*env)->SetIntField(env, lpObject, lpCache->dwVolumeSerialNumber, (jint)lpStruct->dwVolumeSerialNumber);
	(*env)->SetLongField(env, lpObject, lpCache->ftLastWriteTime, toJLong(&(lpStruct->ftLastWriteTime)));
	(*env)->SetLongField(env, lpObject, lpCache->ftLastAccessTime, toJLong(&(lpStruct->ftLastAccessTime)));
	(*env)->SetLongField(env, lpObject, lpCache->ftCreationTime, toJLong(&(lpStruct->ftCreationTime)));
	(*env)->SetIntField(env, lpObject, lpCache->dwFileAttributes, (jint)lpStruct->dwFileAttributes);
}


// WIN32_FIND_DATA

WIN32_FIND_DATA_FID_CACHE WIN32_FIND_DATAFc;

void cacheWIN32_FIND_DATAFids(JNIEnv *env, jobject lpObject, PWIN32_FIND_DATA_FID_CACHE lpCache)
{
	if (lpCache->cached) return;
	lpCache->clazz = (*env)->GetObjectClass(env, lpObject);
	lpCache->cAlternateFileName = (*env)->GetFieldID(env, lpCache->clazz, "cAlternateFileName", "[B");
	lpCache->cFileName = (*env)->GetFieldID(env, lpCache->clazz, "cFileName", "[B");
	lpCache->dwReserved1 = (*env)->GetFieldID(env, lpCache->clazz, "dwReserved1", "I");
	lpCache->dwReserved0 = (*env)->GetFieldID(env, lpCache->clazz, "dwReserved0", "I");
	lpCache->nFileSizeLow = (*env)->GetFieldID(env, lpCache->clazz, "nFileSizeLow", "I");
	lpCache->nFileSizeHigh = (*env)->GetFieldID(env, lpCache->clazz, "nFileSizeHigh", "I");
	lpCache->ftLastWriteTime = (*env)->GetFieldID(env, lpCache->clazz, "ftLastWriteTime", "J");
	lpCache->ftLastAccessTime = (*env)->GetFieldID(env, lpCache->clazz, "ftLastAccessTime", "J");
	lpCache->ftCreationTime = (*env)->GetFieldID(env, lpCache->clazz, "ftCreationTime", "J");
	lpCache->dwFileAttributes = (*env)->GetFieldID(env, lpCache->clazz, "dwFileAttributes", "I");
	lpCache->cached = 1;
}

WIN32_FIND_DATA *getWIN32_FIND_DATAFields(JNIEnv *env, jobject lpObject, WIN32_FIND_DATA *lpStruct)
{
	PWIN32_FIND_DATA_FID_CACHE lpCache = &WIN32_FIND_DATAFc;
	if (!lpCache->cached) cacheWIN32_FIND_DATAFids(env, lpObject, lpCache);
	{
		jbyteArray lpObject1 = (*env)->GetObjectField(env, lpObject, lpCache->cAlternateFileName);
		(*env)->GetByteArrayRegion(env, lpObject1, 0, sizeof(lpStruct->cAlternateFileName), lpStruct->cAlternateFileName);
	}
	{
		jbyteArray lpObject1 = (*env)->GetObjectField(env, lpObject, lpCache->cFileName);
		(*env)->GetByteArrayRegion(env, lpObject1, 0, sizeof(lpStruct->cFileName), lpStruct->cFileName);
	}
	lpStruct->dwReserved1 = (*env)->GetIntField(env, lpObject, lpCache->dwReserved1);
	lpStruct->dwReserved0 = (*env)->GetIntField(env, lpObject, lpCache->dwReserved0);
	lpStruct->nFileSizeLow = (*env)->GetIntField(env, lpObject, lpCache->nFileSizeLow);
	lpStruct->nFileSizeHigh = (*env)->GetIntField(env, lpObject, lpCache->nFileSizeHigh);
	lpStruct->ftLastWriteTime = toFILETIME((*env)->GetLongField(env, lpObject, lpCache->ftLastWriteTime));
	lpStruct->ftLastAccessTime = toFILETIME((*env)->GetLongField(env, lpObject, lpCache->ftLastAccessTime));
	lpStruct->ftCreationTime = toFILETIME((*env)->GetLongField(env, lpObject, lpCache->ftCreationTime));
	lpStruct->dwFileAttributes = (*env)->GetIntField(env, lpObject, lpCache->dwFileAttributes);
	return lpStruct;
}

jsize getLength(TCHAR *target) {
	jsize result = 0;
	while (target[result]) {
		result++;
	}
	return result;
}

void setWIN32_FIND_DATAFields(JNIEnv *env, jobject lpObject, WIN32_FIND_DATA *lpStruct)
{
	PWIN32_FIND_DATA_FID_CACHE lpCache = &WIN32_FIND_DATAFc;
	if (!lpCache->cached) cacheWIN32_FIND_DATAFids(env, lpObject, lpCache);
	{
		jsize length = getLength(lpStruct->cAlternateFileName);
		jbyteArray cAlternateFileName = (*env)->NewByteArray(env, length);
		(*env)->SetByteArrayRegion(env, cAlternateFileName, 0, length, (jbyte *) lpStruct->cAlternateFileName);
		(*env)->SetObjectField(env, lpObject, lpCache->cAlternateFileName, cAlternateFileName);
	}
	{
		jsize length = getLength(lpStruct->cFileName);
		jbyteArray cFileName = (*env)->NewByteArray(env, length);
		(*env)->SetByteArrayRegion(env, cFileName, 0, length, (jbyte *) lpStruct->cFileName);
		(*env)->SetObjectField(env, lpObject, lpCache->cFileName, cFileName);
	}
	(*env)->SetIntField(env, lpObject, lpCache->dwReserved1, (jint)lpStruct->dwReserved1);
	(*env)->SetIntField(env, lpObject, lpCache->dwReserved0, (jint)lpStruct->dwReserved0);
	(*env)->SetIntField(env, lpObject, lpCache->nFileSizeLow, (jint)lpStruct->nFileSizeLow);
	(*env)->SetIntField(env, lpObject, lpCache->nFileSizeHigh, (jint)lpStruct->nFileSizeHigh);
	(*env)->SetLongField(env, lpObject, lpCache->ftLastWriteTime, toJLong(&(lpStruct->ftLastWriteTime)));
	(*env)->SetLongField(env, lpObject, lpCache->ftLastAccessTime, toJLong(&(lpStruct->ftLastAccessTime)));
	(*env)->SetLongField(env, lpObject, lpCache->ftCreationTime, toJLong(&(lpStruct->ftCreationTime)));
	(*env)->SetIntField(env, lpObject, lpCache->dwFileAttributes, (jint)lpStruct->dwFileAttributes);
}
