#include "refresh.h"

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    FindFirstChangeNotification
 * Signature: ([BZI)J
 */
JNIEXPORT jlong JNICALL Java_com_oti_autorefresher_WindowsNatives_FindFirstChangeNotification
   (JNIEnv *env, jclass this, jbyteArray lpPathName, jboolean bWatchSubtree, jint dwNotifyFilter) {

	jlong result;
	jbyte *bytes = (*env)->GetByteArrayElements(env, lpPathName, 0);

	result = (jlong) FindFirstChangeNotification(bytes, bWatchSubtree, dwNotifyFilter);
	(*env)->ReleaseByteArrayElements(env, lpPathName, bytes, 0);

	return result;
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    FindCloseChangeNotification
 * Signature: (J)Z
 */
JNIEXPORT jboolean JNICALL Java_com_oti_autorefresher_WindowsNatives_FindCloseChangeNotification
   (JNIEnv *env, jclass this, jlong hChangeHandle) {

	return (jboolean) FindCloseChangeNotification((HANDLE) hChangeHandle);
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    FindNextChangeNotification
 * Signature: (J)Z
 */
JNIEXPORT jboolean JNICALL Java_com_oti_autorefresher_WindowsNatives_FindNextChangeNotification
   (JNIEnv *env, jclass this, jlong hChangeHandle) {

	return (jboolean) FindNextChangeNotification((HANDLE) hChangeHandle);
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    WaitForMultipleObjects
 * Signature: (I[JZI)I
 */
JNIEXPORT jint JNICALL Java_com_oti_autorefresher_WindowsNatives_WaitForMultipleObjects
   (JNIEnv *env, jclass this, jint nCount, jlongArray lpHandles, jboolean bWaitAll, jint dwMilliseconds) {

	int i;
	jint result;
	HANDLE handles[MAXIMUM_WAIT_OBJECTS];
	jlong *handlePointers = (*env)->GetLongArrayElements(env, lpHandles, 0);

	for (i = 0; i < nCount; i++)
		handles[i] = (HANDLE) handlePointers[i];
	result = WaitForMultipleObjects(nCount, handles, bWaitAll, dwMilliseconds);
	(*env)->ReleaseLongArrayElements(env, lpHandles, handlePointers, 0);

	return result;
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    GetLastError
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_com_oti_autorefresher_WindowsNatives_GetLastError
   (JNIEnv *env, jclass this) {

	return GetLastError();
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    CreateFile
 * Signature: ([BIIIIIJ)J
 */
JNIEXPORT jlong JNICALL Java_com_oti_autorefresher_WindowsNatives_CreateFile
   (JNIEnv *env, jclass that, jbyteArray arg0, jint arg1, jint arg2, jint arg3, jint arg4, jint arg5, jlong arg6)
{
	jbyte *lparg0=NULL;
	jlong rc;

	if (arg0) lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL);
	rc = (jlong)CreateFile(lparg0, arg1, arg2, (LPSECURITY_ATTRIBUTES) arg3, arg4, arg5, (HANDLE) arg6);
	if (arg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, 0);
	return rc;
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    CloseHandle
 * Signature: (J)Z
 */
JNIEXPORT jboolean JNICALL Java_com_oti_autorefresher_WindowsNatives_CloseHandle
   (JNIEnv *env, jclass this, jlong handle) {

	return (jboolean) CloseHandle((HANDLE) handle);
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    waitForNextChange
 * Signature: (JJJJ)Z
 */
JNIEXPORT jboolean JNICALL Java_com_oti_autorefresher_WindowsNatives_waitForNextChange
   (JNIEnv *env, jclass this, jlong handle, jlong nextUSN, jlong journalId, jlong timeout) {

	USN usn; // not used but necessary for the function to work
	DWORD bytesReturned; // not used but necessary for the function to work
	READ_USN_JOURNAL_DATA configuration;

	configuration.StartUsn = nextUSN;
	configuration.ReasonMask = 0xFFFFFFFF; // anything
	configuration.ReturnOnlyOnClose = 0; // notify changes at the time they happen
	configuration.Timeout = timeout;
	configuration.BytesToWaitFor = 1;
	configuration.UsnJournalID = journalId;

	return (jboolean) DeviceIoControl((HANDLE) handle,
									  FSCTL_READ_USN_JOURNAL,
									  &configuration,
									  sizeof(configuration),
									  &usn,
									  sizeof(usn),
									  &bytesReturned,
									  NULL);
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    getJournalChanges
 * Signature: (JJJJ[Lcom/oti/autorefresher/structs/USN_RECORD;[J)Z
 */
JNIEXPORT jboolean JNICALL Java_com_oti_autorefresher_WindowsNatives_getJournalChanges
   (JNIEnv *env, jclass this, jlong handle, jlong startUSN, jlong journalId, jlong timeout, jobjectArray changes, jlongArray nextUSN) {

	jboolean result;
	READ_USN_JOURNAL_DATA configuration;
	BYTE records[(sizeof(USN_RECORD) * 40) + sizeof(USN)];
	DWORD bytesReturned;
	jlong *lpnextUSN = NULL;
	jint nrecords = 0;
	PUSN_RECORD record;
	jclass changeClass;
	jmethodID constructor;
	jobject change;

	configuration.StartUsn = startUSN;
	configuration.ReasonMask = 0xFFFFFFFF; // anything
	configuration.ReturnOnlyOnClose = 0; // notify changes at the time they happen
	configuration.Timeout = timeout * -1000000; // timeout should be in milliseconds
	configuration.BytesToWaitFor = sizeof(records);
	configuration.UsnJournalID = journalId;

	result = DeviceIoControl((HANDLE) handle, FSCTL_READ_USN_JOURNAL,
						 &configuration, sizeof(configuration),
						 records, sizeof(records),
						 &bytesReturned, NULL);

	if (!result)
		return FALSE; // failed

	// set nextUSN
	lpnextUSN = (*env)->GetLongArrayElements(env, nextUSN, NULL);
	CopyMemory(&lpnextUSN[0], records, sizeof(USN));
	(*env)->ReleaseLongArrayElements(env, nextUSN, lpnextUSN, 0);

	// populate array
	record = (PUSN_RECORD) &records[sizeof(USN)];
	changeClass = (*env)->FindClass(env, "com/oti/autorefresher/structs/USN_RECORD");
	constructor = (*env)->GetMethodID(env, changeClass, "<init>", "()V");
	while ((PBYTE) record < (records + bytesReturned)) {
		change = (*env)->NewObject(env, changeClass, constructor);
		setUSN_RECORDFields(env, change, record);
		(*env)->SetObjectArrayElement(env, changes, nrecords++, change);
		record = (PUSN_RECORD) ((PBYTE) record + record->RecordLength);
	}
	return TRUE;
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    queryJournal
 * Signature: (JLcom/oti/autorefresher/win2k/USN_JOURNAL_DATA;)Z
 */
JNIEXPORT jboolean JNICALL Java_com_oti_autorefresher_WindowsNatives_queryJournal
   (JNIEnv *env, jclass this, jlong handle, jobject dataContainer) {

	jboolean result;
	USN_JOURNAL_DATA data;
	DWORD bytesReturned;
	
	result = (jboolean) DeviceIoControl((HANDLE) handle, FSCTL_QUERY_USN_JOURNAL,
						   NULL, 0,
						   &data, sizeof(data),
						   &bytesReturned, NULL);

	if (result)
		setUSN_JOURNAL_DATAFields(env, dataContainer, &data);

	return result;
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    FindFirstFile
 * Signature: ([BLcom/oti/autorefresher/structs/WIN32_FIND_DATA;)J
 */
JNIEXPORT jlong JNICALL Java_com_oti_autorefresher_WindowsNatives_FindFirstFile
   (JNIEnv *env, jclass this, jbyteArray fileName, jobject data)
{
	jbyte *lpFileName;
	WIN32_FIND_DATA lpFindFileData;
	jlong result;

	lpFileName = (*env)->GetByteArrayElements(env, fileName, NULL);
	result = (jlong)FindFirstFile(lpFileName, &lpFindFileData);
	(*env)->ReleaseByteArrayElements(env, fileName, lpFileName, 0);
	setWIN32_FIND_DATAFields(env, data, &lpFindFileData);
	return result;
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    FindNextFile
 * Signature: (JLcom/oti/autorefresher/structs/WIN32_FIND_DATA;)Z
 */
JNIEXPORT jboolean JNICALL Java_com_oti_autorefresher_WindowsNatives_FindNextFile
   (JNIEnv *env, jclass this, jlong handle, jobject data)
{
	WIN32_FIND_DATA lpFindFileData;
	jboolean result;

	result = (jboolean)FindNextFile(handle, &lpFindFileData);
	setWIN32_FIND_DATAFields(env, data, &lpFindFileData);
	return result;
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    FindClose
 * Signature: (J)Z
 */
JNIEXPORT jboolean JNICALL Java_com_oti_autorefresher_WindowsNatives_FindClose
   (JNIEnv *env, jclass this, jlong arg0)
{
	return (jboolean)FindClose(arg0);
}

/*
 * Class:     com_oti_autorefresher_WindowsNatives
 * Method:    GetFileInformationByHandle
 * Signature: (JLcom/oti/autorefresher/structs/BY_HANDLE_FILE_INFORMATION;)Z
 */
JNIEXPORT jboolean JNICALL Java_com_oti_autorefresher_WindowsNatives_GetFileInformationByHandle
   (JNIEnv *env, jclass this, jlong arg0, jobject arg1)
{
	BY_HANDLE_FILE_INFORMATION _arg1, *lparg1=NULL;
	jboolean rc;

	if (arg1) lparg1 = getBY_HANDLE_FILE_INFORMATIONFields(env, arg1, &_arg1);
	rc = (jboolean)GetFileInformationByHandle((HANDLE) arg0, lparg1);
	if (arg1) setBY_HANDLE_FILE_INFORMATIONFields(env, arg1, lparg1);
	return rc;
}
