package com.example.autorefresh.ui;

/**********************************************************************
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.example.autorefresh.AutoRefreshPlugin;
import com.example.autorefresh.ISearch;
import com.example.autorefresh.ISearchListener;

/**
 * The <code>SearchActionDelegate</code> provides the user with a simple
 * way to start the <code>AutoRefreshPlugin</code> and also to make requests
 * to search the contents of the workspace for resources that are out of synch.
 */
public class SearchActionDelegate implements IWorkbenchWindowActionDelegate, ISearchListener {
	/**
	 * The search that this delegate requested be performed.
	 */
	private ISearch fSearch;
	/**
	 * The action this is a delegate to.
	 */
	private IAction fAction;
	/**
	 * The window this delegate was created in.
	 */
	private IWorkbenchWindow fWindow;
	
	/**
	 * Posts a new search to the <code>AutoRefreshPlugin</code>.
	 * 
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		fSearch= AutoRefreshPlugin.getDefault().createSearch(null);
		fAction.setEnabled(false);
		AutoRefreshPlugin.getDefault().search(fSearch);
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#init(IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
		fWindow= window;
		AutoRefreshPlugin.getDefault().addSearchListener(this);
	}
	
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */	
	public void selectionChanged(IAction action, ISelection selection) {
		fAction= action;
	}
	
	/**
	 * @see IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
		AutoRefreshPlugin.getDefault().removeSearchListener(this);
		fSearch= null;
		fAction= null;
		fWindow= null;
	}	

	/**
	 * @see ISearchListener#searchComplete(ISearch)
	 */
	public void searchComplete(ISearch search) {
		if (fSearch == search) {
			fSearch= null;
			fAction.setEnabled(true);
		}
	}
}



