package com.example.autorefresh.internal;

/**********************************************************************
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.Comparator;

import org.eclipse.core.runtime.IPath;

/**
 * A <code>Comparator</code> that compares <code>IPath</code>
 * objects.  Longer paths are considered to be less than shorter
 * ones.  This guareentes that sorted collections return the longer
 * path first.
 */
public class PathComparator implements Comparator {

	/*
	 * @see Comparator#compare(Object, Object)
	 */
	public int compare(Object o1, Object o2) {
		IPath path1= (IPath)o1;
		IPath path2= (IPath)o2;
		
		String s1= path1.makeAbsolute().toString();
		String s2= path2.makeAbsolute().toString();
		
		int diff= s1.length() - s2.length();
		
		if (diff != 0) {
			return -diff;
		}
		return s1.compareTo(s2);
	}

}
