package com.example.autorefresh;

/**********************************************************************
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.List;

import org.eclipse.core.resources.IResource;

/**
 * The <code>ISearchCollector</code> is used by <code>IScanner</code>
 * implementations to record additions, deletions, changes and transforms.
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * WARNING:  This is experimental API.  It is likely to change in future releases.
 */
public interface ISearchCollector {
	/**
	 * Records that a file in the given <code>parent</code> resource
	 * has been created.  The <code>String</code> specified is the simple
	 * name of that file.
	 */
	void recordAddition(IResource parent, String addition);
	
	/**
	 * Records that the given resource was deleted.
	 * <p>
	 * If a file has changed from being a file to a folder
	 */
	void recordDeletion(IResource deletion);
	
	/**
	 * Records that the given resource was changed.  A resource is changed if
	 * its timestamp has been modified, or it has changed from being remote to
	 * being local.
	 */
	void recordChange(IResource change);
	
	/**
	 * Records that the given resource has undergone the switched between
	 * being either an <code>IFile</code> or an <code>IContainer</code>.
	 */
	void recordTransform(IResource transform);
}
