package com.example.autorefresh;

/**********************************************************************
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;

/**
 * An <code>ISearch</code> may be obtained using the following code snippet:
 * <code>
 * IResource[] resources= placesWhereResourcesCouldChange();
 * IAutoRefreshSearch search= AutoRefreshPlugin.getDefault().createSearch(resources);
 * </code>
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * WARNING:  This is experimental API.  It is likely to change in future releases.
 */
public interface ISearch {
	
	/**
	 * Answers the array of <code>IResource</code> objects that should be
	 * searched when this search is carried out.
	 */
	IResource[] getResources();
	
	/**
	 * Requests that this search be canceled.
	 */
	void cancel();
	
	/**
	 * Answers <code>true</code> if this search has been canceled.
	 */
	boolean isCanceled();
}
