package com.example.autorefresh;

/**********************************************************************
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

import org.eclipse.core.resources.IResource;

/**
 * An <code>IScanner</code> is responsible for scanning the filesystem to 
 * determine if the workbench model of the resources is up to date with the
 * actual resources in the filesystem.
 * <p>
 * Implementations of this interface should register with the 
 * <code>AutoRefreshPlugin</code> in order to override the default implementation
 * of the auto refresh scanner.
 * <p>
 * This interface may be implemented by clients.
 * </p>
 * WARNING:  This is experimental API.  It is likely to change in future releases.
 */
public interface IScanner {
	/**
	 * Requests that this scanner search the filesystem starting in the 
	 * <code>resource</code> for additions, deletions, changes and transforms 
	 * to the resources located under <code>resource</code>.
	 * <p>
	 * Results should be recorded in the given <code>ISearchCollector</code>.
	 * <p>
	 * The given <code>search</code> must be polled periodically in
	 * order to support cancellation.
	 *
	 * @see ISearchCollector
	 */
	void scan(IResource resource, ISearchCollector collector, ISearch search);
}
