/*
 * Decompiled with CFR 0.152.
 */
package com.example.autorefresh.ui;

import com.example.autorefresh.AutoRefreshPlugin;
import com.example.autorefresh.ISearch;
import com.example.autorefresh.ISearchListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RefreshActionDelegate
implements IWorkbenchWindowActionDelegate,
ISearchListener {
    private IAction fAction;
    private IWorkbenchWindow fWindow;

    public void run(IAction action) {
        this.setStatus(null, "Refreshing resources from local");
        this.fAction.setEnabled(false);
        Thread t = new Thread(new Runnable(){

            public void run() {
                RefreshActionDelegate.this.refresh();
            }
        }, "Background refresh");
        t.start();
    }

    private void refresh() {
        Display display;
        Shell shell;
        AutoRefreshPlugin.getDefault().refresh(null);
        Runnable r = new Runnable(){

            public void run() {
                if (RefreshActionDelegate.this.fWindow != null && !RefreshActionDelegate.this.fWindow.getShell().isDisposed()) {
                    RefreshActionDelegate.this.setStatus(null, "Refresh complete");
                    RefreshActionDelegate.this.checkEnabled();
                }
            }
        };
        if (this.fWindow != null && (shell = this.fWindow.getShell()) != null && (display = shell.getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec(r);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        AutoRefreshPlugin.getDefault().addSearchListener((ISearchListener)this);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
        this.checkEnabled();
    }

    public void dispose() {
        AutoRefreshPlugin plugin = AutoRefreshPlugin.getDefault();
        if (plugin != null) {
            plugin.removeSearchListener((ISearchListener)this);
        }
        this.fWindow = null;
        this.fAction = null;
    }

    public void searchComplete(ISearch search) {
        this.checkEnabled();
    }

    private void checkEnabled() {
        if (this.fAction != null) {
            AutoRefreshPlugin plugin = AutoRefreshPlugin.getDefault();
            if (!plugin.isAutoRefreshing()) {
                boolean enabled = plugin.hasSearchesToRefresh();
                if (this.fAction.isEnabled() != enabled) {
                    this.fAction.setEnabled(enabled);
                }
            } else if (this.fAction.isEnabled()) {
                this.fAction.setEnabled(false);
            }
        }
    }

    private void setStatus(Image image, String status) {
        IWorkbenchPart part = this.fWindow.getActivePage().getActivePart();
        if (part instanceof IViewPart) {
            IViewPart view = (IViewPart)part;
            IStatusLineManager manager = view.getViewSite().getActionBars().getStatusLineManager();
            manager.setMessage(image, status);
        } else {
            System.out.println(status);
        }
    }
}

