/*
 * Decompiled with CFR 0.152.
 */
package com.example.autorefresh.internal;

import com.example.autorefresh.AutoRefreshPlugin;
import com.example.autorefresh.internal.AutoRefreshSearch;
import com.example.autorefresh.internal.SearchEngine;

public class SearchManager
implements Runnable {
    private boolean fCanceled = false;
    private AutoRefreshSearch fSearch = null;
    private SearchEngine fSearchEngine;

    public void run() {
        if (AutoRefreshPlugin.getDefault().isDebugging()) {
            System.out.println("Starting auto-search");
        }
        while (!this.fCanceled) {
            AutoRefreshSearch search = this.waitForSearch(AutoRefreshPlugin.getDefault().getSearchDelay());
            if (this.fCanceled) continue;
            if (AutoRefreshPlugin.getDefault().isDebugging()) {
                System.out.println("Starting search");
            }
            this.fSearchEngine = new SearchEngine(search);
            this.fSearchEngine.run();
            this.fSearchEngine = null;
            if (!AutoRefreshPlugin.getDefault().isDebugging()) continue;
            System.out.println("Search finished");
        }
    }

    public synchronized void shutdown() {
        this.fCanceled = true;
        this.fSearch = null;
        this.notifyAll();
        if (this.fSearchEngine != null) {
            this.fSearchEngine.shutdown();
        }
        this.fSearchEngine = null;
    }

    public synchronized void search(AutoRefreshSearch search) {
        if (search == null) {
            return;
        }
        if (this.fSearchEngine != null) {
            this.fSearchEngine.search(search);
        } else {
            this.fSearch = search;
            this.notifyAll();
        }
    }

    private synchronized AutoRefreshSearch waitForSearch(long wait) {
        if (this.fSearch == null) {
            try {
                this.wait(wait);
            }
            catch (InterruptedException e) {
                this.shutdown();
            }
        }
        if (this.fSearch != null) {
            AutoRefreshSearch search = this.fSearch;
            this.fSearch = null;
            return search;
        }
        return AutoRefreshSearch.createDefaultSearch();
    }
}

