/*
 * Decompiled with CFR 0.152.
 */
package com.example.autorefresh.internal;

import com.example.autorefresh.AutoRefreshPlugin;
import com.example.autorefresh.IScanner;
import com.example.autorefresh.ISearch;
import com.example.autorefresh.internal.AutoRefreshSearch;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;

public class SearchEngine
implements Runnable {
    private boolean fIsRunning;
    private List fSearches = new ArrayList(10);
    private AutoRefreshSearch fDefaultSearch;
    private AutoRefreshSearch fCurrentSearch;

    public SearchEngine(AutoRefreshSearch search) {
        if (search != null) {
            this.fSearches.add(search);
        }
    }

    public void search(ISearch search) {
        if (!(search instanceof AutoRefreshSearch)) {
            return;
        }
        AutoRefreshSearch s = (AutoRefreshSearch)search;
        if (s.isDefaultSearch()) {
            if (this.fDefaultSearch == null) {
                this.fDefaultSearch = s;
            }
        } else {
            this.fSearches.add(s);
        }
        if (AutoRefreshPlugin.getDefault().isDebugging()) {
            System.out.println("Added search: " + s);
        }
    }

    public void run() {
        this.fIsRunning = true;
        while (this.isRunning() && this.hasNext()) {
            this.fCurrentSearch = this.nextSearch();
            IResource[] resources = this.fCurrentSearch.getResources();
            long time = System.currentTimeMillis();
            if (AutoRefreshPlugin.getDefault().isDebugging()) {
                System.out.println("Search started: " + this.fCurrentSearch);
            }
            int i = 0;
            int length = resources.length;
            while (this.isRunning() && i < length) {
                IResource resource = resources[i];
                IScanner scanner = AutoRefreshPlugin.getDefault().getScanner(resource);
                scanner.scan(resource, this.fCurrentSearch, this.fCurrentSearch);
                ++i;
            }
            time = System.currentTimeMillis() - time;
            AutoRefreshPlugin.getDefault().searchComplete(this.fCurrentSearch);
            if (!AutoRefreshPlugin.getDefault().isDebugging()) continue;
            System.out.println("Search complete: " + time + "ms " + this.fCurrentSearch);
        }
        this.fIsRunning = false;
    }

    public boolean isRunning() {
        return this.fIsRunning;
    }

    public void shutdown() {
        this.fCurrentSearch.cancel();
        this.fSearches = new ArrayList(0);
        this.fIsRunning = false;
    }

    private AutoRefreshSearch nextSearch() {
        if (!this.fSearches.isEmpty()) {
            return (AutoRefreshSearch)this.fSearches.remove(0);
        }
        AutoRefreshSearch defaultSearch = this.fDefaultSearch;
        this.fDefaultSearch = null;
        return defaultSearch;
    }

    private boolean hasNext() {
        return !this.fSearches.isEmpty() || this.fDefaultSearch != null;
    }
}

