/*
 * Decompiled with CFR 0.152.
 */
package com.example.autorefresh.internal;

import com.example.autorefresh.AutoRefreshPlugin;
import com.example.autorefresh.internal.AutoRefreshSearch;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class Refresher {
    public void refresh(IProgressMonitor monitor, final List searches) {
        block7: {
            if (searches == null || searches.isEmpty()) {
                return;
            }
            IWorkspaceRunnable run = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (AutoRefreshPlugin.getDefault().isDebugging()) {
                        System.out.println("Refresh starting");
                    }
                    long time = System.currentTimeMillis();
                    Refresher.this.refreshAll(monitor, searches);
                    time = System.currentTimeMillis() - time;
                    if (AutoRefreshPlugin.getDefault().isDebugging()) {
                        System.out.println("Refresh: " + time);
                        System.out.println("Refresh finished");
                    }
                }
            };
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            boolean isAutoBuilding = workspace.isAutoBuilding();
            try {
                try {
                    if (isAutoBuilding) {
                        this.setAutoBuilding(workspace, false);
                    }
                    workspace.run(run, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (isAutoBuilding) {
                    this.setAutoBuilding(workspace, true);
                }
                throw throwable;
            }
            Object var7_9 = null;
            if (!isAutoBuilding) break block7;
            this.setAutoBuilding(workspace, true);
        }
    }

    private void refreshAll(IProgressMonitor monitor, List searches) {
        Iterator i = searches.iterator();
        while (i.hasNext()) {
            AutoRefreshSearch search = (AutoRefreshSearch)i.next();
            if (search.isEmpty()) continue;
            this.refresh(monitor, search);
        }
    }

    private void refresh(IProgressMonitor monitor, AutoRefreshSearch search) {
        if (AutoRefreshPlugin.getDefault().isDebugging()) {
            System.out.println("Refreshing: " + search);
        }
        if (this.hasDepthZeroResources(search)) {
            this.refreshDepthZeroResources(monitor, search);
        }
        if (this.hasDepthOneResources(search)) {
            this.refreshDepthOneResources(monitor, search);
        }
        if (this.hasDepthInfiniteResources(search)) {
            this.refreshDepthInfiniteResources(monitor, search);
        }
    }

    private void refreshDepthZeroResources(IProgressMonitor monitor, AutoRefreshSearch search) {
        Set depthZero = this.getDepthZeroResources(search);
        if (depthZero != null) {
            Iterator i = depthZero.iterator();
            while (i.hasNext()) {
                IResource resource = (IResource)i.next();
                try {
                    resource.refreshLocal(0, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void refreshDepthOneResources(IProgressMonitor monitor, AutoRefreshSearch search) {
        Map depthOne = this.getDepthOneResources(search);
        Iterator i = depthOne.keySet().iterator();
        while (i.hasNext()) {
            IContainer container = (IContainer)i.next();
            List additions = (List)depthOne.get(container);
            Iterator j = additions.iterator();
            while (j.hasNext()) {
                String name = (String)j.next();
                if (container.findMember(name) == null) continue;
                j.remove();
            }
            try {
                container.refreshLocal(1, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return;
            }
            IResource[] members = null;
            try {
                members = container.members();
            }
            catch (CoreException e) {
                e.printStackTrace();
                return;
            }
            if (members == null) continue;
            Iterator j2 = additions.iterator();
            while (j2.hasNext()) {
                String name = (String)j2.next();
                IResource member = this.findMember(members, name);
                if (!(member instanceof IContainer)) continue;
                try {
                    member.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void refreshDepthInfiniteResources(IProgressMonitor monitor, AutoRefreshSearch search) {
        Set depthInfinite = this.getDepthInfiniteResources(search);
        if (depthInfinite != null) {
            Iterator i = depthInfinite.iterator();
            while (i.hasNext()) {
                IResource resource = (IResource)i.next();
                try {
                    resource.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean hasDepthZeroResources(AutoRefreshSearch search) {
        return search.hasChanges() || search.hasDeletions();
    }

    private Set getDepthZeroResources(AutoRefreshSearch search) {
        Set depthZero = search.getChanges();
        if (depthZero == null) {
            depthZero = search.getDeletions();
        } else {
            Set deletions = search.getDeletions();
            if (deletions != null) {
                depthZero.addAll(deletions);
            }
        }
        return depthZero;
    }

    private boolean hasDepthOneResources(AutoRefreshSearch search) {
        return search.hasAdditions();
    }

    private Map getDepthOneResources(AutoRefreshSearch search) {
        return search.getAdditions();
    }

    private boolean hasDepthInfiniteResources(AutoRefreshSearch search) {
        return search.hasTransforms();
    }

    private Set getDepthInfiniteResources(AutoRefreshSearch search) {
        return search.getTransforms();
    }

    private IResource findMember(IResource[] members, String name) {
        int i = 0;
        while (i < members.length) {
            IResource member = members[i];
            if (name.equals(member.getName())) {
                return member;
            }
            ++i;
        }
        return null;
    }

    private void setAutoBuilding(IWorkspace workspace, boolean autoBuilding) {
        IWorkspaceDescription description = workspace.getDescription();
        description.setAutoBuilding(autoBuilding);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

