/*
 * Decompiled with CFR 0.152.
 */
package com.example.autorefresh.internal;

import com.example.autorefresh.IScanner;
import com.example.autorefresh.ISearch;
import com.example.autorefresh.ISearchCollector;
import java.io.File;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class DefaultScanner
implements IScanner {
    public void scan(IResource resource, ISearchCollector collector, ISearch search) {
        IPath path = resource.getLocation();
        if (path != null) {
            File file = path.toFile();
            this.checkResource(resource, file, collector, search);
        }
    }

    private void checkResource(IResource resource, File file, ISearchCollector collector, ISearch search) {
        if (resource instanceof IContainer) {
            this.checkContainer((IContainer)resource, file, collector, search);
        } else if (resource instanceof IFile) {
            this.checkFile((IFile)resource, file, collector);
        }
    }

    private void checkContainer(IContainer container, File file, ISearchCollector collector, ISearch search) {
        if (!file.isDirectory()) {
            collector.recordTransform((IResource)container);
            return;
        }
        IResource[] members = null;
        try {
            members = container.members();
        }
        catch (CoreException e) {
            this.checkContainerExistence(container, file, collector);
            return;
        }
        String[] list = file.list();
        if (list != null) {
            int hits = 0;
            int i = 0;
            while (!search.isCanceled() && i < members.length) {
                IResource member = members[i];
                if (!this.searchInResource(member, file, list, collector, search)) {
                    collector.recordDeletion(member);
                } else {
                    ++hits;
                }
                ++i;
            }
            if (!search.isCanceled() && hits != list.length) {
                i = 0;
                while (i < list.length) {
                    if (!this.resourceExists(list[i], members)) {
                        collector.recordAddition((IResource)container, list[i]);
                    }
                    ++i;
                }
            }
        }
    }

    private boolean searchInResource(IResource resource, File parent, String[] list, ISearchCollector collector, ISearch search) {
        String name = resource.getName();
        int i = 0;
        while (i < list.length) {
            if (name.equals(list[i]) && !search.isCanceled()) {
                this.checkResource(resource, new File(parent, list[i]), collector, search);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean resourceExists(String name, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (name.equals(resources[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void checkFile(IFile resource, File file, ISearchCollector collector) {
        if (file.isDirectory()) {
            collector.recordTransform((IResource)resource);
        }
        if (resource instanceof org.eclipse.core.internal.resources.File) {
            org.eclipse.core.internal.resources.File fileResource = (org.eclipse.core.internal.resources.File)resource;
            ResourceInfo info = fileResource.getResourceInfo(false, false);
            if (info == null) {
                collector.recordDeletion((IResource)resource);
                return;
            }
            if (fileResource.isLocal(info.getFlags(), 0)) {
                long timestamp;
                if (info != null && (timestamp = info.getLocalSyncInfo()) != file.lastModified()) {
                    collector.recordChange((IResource)resource);
                }
            } else if (file.exists()) {
                collector.recordChange((IResource)resource);
            }
        }
    }

    private void checkContainerExistence(IContainer container, File file, ISearchCollector collector) {
        if (!file.exists()) {
            collector.recordDeletion((IResource)container);
        }
    }
}

