/*
 * Decompiled with CFR 0.152.
 */
package com.example.autorefresh.internal;

import com.example.autorefresh.ISearch;
import com.example.autorefresh.ISearchCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class AutoRefreshSearch
implements ISearch,
ISearchCollector {
    private IResource[] fResources;
    private boolean fCanceled;
    private Map fAdditions;
    private Set fDeletions;
    private Set fChanges;
    private Set fTransforms;
    private boolean fIsDefaultSearch;

    public AutoRefreshSearch(IResource[] resources) {
        this(resources, false);
    }

    private AutoRefreshSearch(IResource[] resources, boolean isDefault) {
        this.fResources = resources == null || resources.length == 0 ? this.getAllProjects() : resources;
        this.fIsDefaultSearch = isDefault;
    }

    private IResource[] getAllProjects() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        if (root != null) {
            return root.getProjects();
        }
        return null;
    }

    static AutoRefreshSearch createDefaultSearch() {
        return new AutoRefreshSearch(null, true);
    }

    public IResource[] getResources() {
        return this.fResources;
    }

    public void cancel() {
        this.fCanceled = true;
    }

    public boolean isCanceled() {
        return this.fCanceled;
    }

    public void recordAddition(IResource parent, String addition) {
        ArrayList<String> additions;
        if (addition == null || parent == null) {
            return;
        }
        if (this.fAdditions == null) {
            this.fAdditions = new HashMap(5);
        }
        if ((additions = (ArrayList<String>)this.fAdditions.get(parent)) == null) {
            additions = new ArrayList<String>(5);
            this.fAdditions.put(parent, additions);
        }
        additions.add(addition);
    }

    public void recordDeletion(IResource deletion) {
        if (deletion == null) {
            return;
        }
        if (this.fDeletions == null) {
            this.fDeletions = new HashSet(5);
        }
        this.fDeletions.add(deletion);
    }

    public void recordChange(IResource change) {
        if (change == null) {
            return;
        }
        if (this.fChanges == null) {
            this.fChanges = new HashSet(5);
        }
        this.fChanges.add(change);
    }

    public void recordTransform(IResource transform) {
        if (transform == null) {
            return;
        }
        if (this.fTransforms == null) {
            this.fTransforms = new HashSet(5);
        }
        this.fTransforms.add(transform);
    }

    boolean isDefaultSearch() {
        return this.fIsDefaultSearch;
    }

    Map getAdditions() {
        if (this.fCanceled) {
            return null;
        }
        return this.fAdditions;
    }

    Set getDeletions() {
        if (this.fCanceled) {
            return null;
        }
        return this.fDeletions;
    }

    Set getChanges() {
        if (this.fCanceled) {
            return null;
        }
        return this.fChanges;
    }

    Set getTransforms() {
        if (this.fCanceled) {
            return null;
        }
        return this.fTransforms;
    }

    boolean hasAdditions() {
        if (this.fCanceled) {
            return false;
        }
        return this.fAdditions != null;
    }

    boolean hasChanges() {
        if (this.fCanceled) {
            return false;
        }
        return this.fChanges != null;
    }

    boolean hasDeletions() {
        if (this.fCanceled) {
            return false;
        }
        return this.fDeletions != null;
    }

    boolean hasTransforms() {
        if (this.fCanceled) {
            return false;
        }
        return this.fTransforms != null;
    }

    public boolean isEmpty() {
        return !this.hasAdditions() && !this.hasChanges() && !this.hasDeletions() && !this.hasTransforms();
    }
}

